/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.builder;

import java.lang.reflect.Constructor;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import net.sf.cuf.model.AspectAdapter;
import net.sf.cuf.model.BufferedValueHolder;
import net.sf.cuf.model.DelegateAccess;
import net.sf.cuf.model.IndexedAdapter;
import net.sf.cuf.model.LOVMapper;
import net.sf.cuf.model.MixedAccessAdapter;
import net.sf.cuf.model.MultiSelectionInList;
import net.sf.cuf.model.PropertiesAdapter;
import net.sf.cuf.model.SelectionInList;
import net.sf.cuf.model.ValueHolder;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.model.converter.FormatConverter;
import net.sf.cuf.model.converter.RegExpConverter;
import net.sf.cuf.model.converter.TypeConverter;
import net.sf.cuf.model.ui.ButtonModelAdapter;
import net.sf.cuf.model.ui.ComboBoxModelAdapter;
import net.sf.cuf.model.ui.DocumentAdapter;
import net.sf.cuf.model.ui.FilteringListModelAdapter;
import net.sf.cuf.model.ui.LOVAdapter;
import net.sf.cuf.model.ui.LabelAdapter;
import net.sf.cuf.model.ui.ListModelAdapter;
import net.sf.cuf.model.ui.ListTableMapper;
import net.sf.cuf.model.ui.MultiSelectionListModelAdapter;
import net.sf.cuf.model.ui.MultiSelectionTableModelAdapter;
import net.sf.cuf.model.ui.TableSelectionModel;
import net.sf.cuf.model.ui.ToolTipAdapter;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import org.jdom2.Element;

class DataBindingBuilderDelegate
implements SwingXMLBuilder.BuilderDelegate {
    private static final String SELECTION_HOLDER = ".selectionHolder";
    private static final String IS_INDEX_IN_LIST_HOLDER = ".isIndexInList";
    private static final String LIST_HOLDER = ".listHolder";

    DataBindingBuilderDelegate() {
    }

    @Override
    public void build(SwingXMLBuilder pBuilder, Element pDataBindingElement) {
        List<Element> bindings = pDataBindingElement.getChildren();
        for (Element element : bindings) {
            String objectType = element.getName();
            Object object = null;
            String id = element.getAttributeValue("id");
            boolean found = true;
            try {
                if (objectType.equals("valueholder")) {
                    object = this.createValueHolder(element, id);
                } else if (objectType.equals("bufferedholder")) {
                    object = this.createBufferdValueHolder(element, id, pBuilder);
                } else if (objectType.equals("aspectadapter")) {
                    object = this.createAspectAdapter(element, id, pBuilder);
                } else if (objectType.equals("indexedadapter")) {
                    object = this.createIndexedAdapter(element, pBuilder);
                } else if (objectType.equals("indexinlist")) {
                    object = this.createIndexInList(element, id, pBuilder);
                } else if (objectType.equals("propertiesadapter")) {
                    object = this.createPropertiesAdapter(element, id, pBuilder);
                } else if (objectType.equals("typeconverter")) {
                    object = this.createTypeConverter(element, id, pBuilder);
                } else if (objectType.equals("formatconverter")) {
                    object = this.createFormatConverter(element, id, pBuilder);
                } else if (objectType.equals("regexpconverter")) {
                    object = this.createRegexpConverter(element, id, pBuilder);
                } else if (objectType.equals("converterinsync")) {
                    object = this.createConverterInSync(element, id, pBuilder);
                } else if (objectType.equals("selectioninlist")) {
                    object = this.createSelectionInList(element, id, pBuilder);
                } else if (objectType.equals("multiselectioninlist")) {
                    object = this.createMultiSelectionInList(element, id, pBuilder);
                } else if (objectType.equals("setvalue")) {
                    this.setValue(element, pBuilder);
                } else if (objectType.equals("documentadapter")) {
                    object = this.createDocumentAdapter(element, pBuilder);
                } else if (objectType.equals("buttonadapter")) {
                    object = this.createButtonAdapter(element, pBuilder);
                } else if (objectType.equals("comboboxadapter")) {
                    object = this.createComboboxAdapter(element, pBuilder);
                } else if (objectType.equals("listadapter")) {
                    object = this.createListAdapter(element, pBuilder);
                } else if (objectType.equals("filteringlistadapter")) {
                    object = this.createFilteringListAdapter(element, pBuilder);
                } else if (objectType.equals("tableadapter")) {
                    object = this.createTableAdapter(element, pBuilder);
                } else if (objectType.equals("changeAction")) {
                    this.createListener(element, pBuilder);
                } else if (objectType.equals("lovmapper")) {
                    object = this.createLOVMapper(element, pBuilder);
                } else if (objectType.equals("tooltipadapter")) {
                    object = this.createToolTipAdapter(element, pBuilder);
                } else if (objectType.equals("labeladapter")) {
                    object = this.createLabelAdapter(element, pBuilder);
                } else if (objectType.equals("lovadapter")) {
                    object = this.createLOVAdapter(element, pBuilder);
                } else {
                    found = false;
                }
            }
            catch (IllegalArgumentException e) {
                throw SwingXMLBuilder.createException("problems during creating " + objectType, e, element);
            }
            if (!found) {
                throw SwingXMLBuilder.createException("unknown data binding " + objectType, element);
            }
            if (id == null || object == null) continue;
            if (pBuilder.getNameToNonVisual().containsKey(id)) {
                throw SwingXMLBuilder.createException("nonvisual with id " + id + " already defined", element);
            }
            if (object instanceof ValueModel) {
                ((ValueModel)object).setName(id);
            }
            pBuilder.getNameToNonVisual().put(id, object);
        }
    }

    private Object createValueHolder(Element pElement, String pId) throws IllegalArgumentException {
        if (pId == null) {
            throw SwingXMLBuilder.createException("id of " + pElement.getName() + " must not be null", pElement);
        }
        return new ValueHolder();
    }

    private Object createBufferdValueHolder(Element pElement, String pId, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        boolean deepCopy;
        if (pId == null) {
            throw SwingXMLBuilder.createException("id of " + pElement.getName() + " must not be null", pElement);
        }
        String subjectId = pElement.getAttributeValue("subject");
        Object subject = pBuilder.getNonVisualObject(subjectId);
        String triggerId = pElement.getAttributeValue("trigger");
        Object trigger = pBuilder.getNonVisualObject(triggerId);
        boolean bl = deepCopy = pElement.getAttribute("deepcopy") != null;
        if (!(subject instanceof ValueModel)) {
            throw SwingXMLBuilder.createException("no subject found for " + subjectId, pElement);
        }
        if (!(trigger instanceof ValueModel)) {
            throw SwingXMLBuilder.createException("no trigger found for " + triggerId, pElement);
        }
        return new BufferedValueHolder((ValueModel)subject, (ValueModel)trigger, deepCopy);
    }

    private Object createAspectAdapter(Element pElement, String pId, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        if (pId == null) {
            throw SwingXMLBuilder.createException("id of " + pElement.getName() + " must not be null", pElement);
        }
        String triggerId = pElement.getAttributeValue("trigger");
        Object trigger = pBuilder.getNonVisualObject(triggerId);
        String getPrefix = pElement.getAttributeValue("getprefix");
        String setPrefix = pElement.getAttributeValue("setprefix");
        String access = pElement.getAttributeValue("access");
        if (!(trigger instanceof ValueModel)) {
            throw SwingXMLBuilder.createException("no trigger found for " + triggerId, pElement);
        }
        Class<?> sourceClass = SwingXMLBuilder.getClass(pElement);
        if (getPrefix == null) {
            getPrefix = "get";
        }
        if (setPrefix == null) {
            setPrefix = "set";
        }
        AspectAdapter<ValueModel<Object>> aspectAdapter = sourceClass == null ? new AspectAdapter<ValueModel>((ValueModel)trigger, access, getPrefix, setPrefix) : new AspectAdapter((ValueModel)trigger, sourceClass, access, getPrefix, setPrefix);
        return aspectAdapter;
    }

    private Object createIndexedAdapter(Element pElement, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        String triggerId = pElement.getAttributeValue("trigger");
        ValueModel trigger = this.getValueModel(pElement, triggerId, pBuilder);
        IndexedAdapter indexedAdapter = new IndexedAdapter(trigger);
        return indexedAdapter;
    }

    private Object createIndexInList(Element pElement, String pId, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        if (pId == null) {
            throw SwingXMLBuilder.createException("id of " + pElement.getName() + " must not be null", pElement);
        }
        String triggerId = pElement.getAttributeValue("ref");
        ValueModel<?> trigger = this.getValueModel(pElement, triggerId, pBuilder);
        if (!(trigger instanceof IndexedAdapter)) {
            throw SwingXMLBuilder.createException("no IndexedAdapter found for " + triggerId, pElement);
        }
        ValueModel<Boolean> indexInList = ((IndexedAdapter)trigger).isIndexInList();
        return indexInList;
    }

    private Object createPropertiesAdapter(Element pElement, String pId, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        if (pId == null) {
            throw SwingXMLBuilder.createException("id of " + pElement.getName() + " must not be null", pElement);
        }
        String key = pElement.getAttributeValue("key");
        String defaultValue = pElement.getAttributeValue("default");
        Object properties = pBuilder.getNonVisualObject(pElement.getAttributeValue("ref"));
        if (!(properties instanceof Properties)) {
            throw SwingXMLBuilder.createException("not properties object found for " + key, pElement);
        }
        return new PropertiesAdapter((Properties)properties, key, defaultValue);
    }

    private Object createTypeConverter(Element pElement, String pId, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        TypeConverter typeConverter;
        if (pId == null) {
            throw SwingXMLBuilder.createException("id of " + pElement.getName() + " must not be null", pElement);
        }
        String triggerId = pElement.getAttributeValue("trigger");
        Object trigger = pBuilder.getNonVisualObject(triggerId);
        if (!(trigger instanceof ValueModel)) {
            throw SwingXMLBuilder.createException("no trigger found for " + triggerId, pElement);
        }
        Class<?> converterClass = SwingXMLBuilder.getClass(pElement);
        if (!TypeConverter.class.isAssignableFrom(converterClass)) {
            throw SwingXMLBuilder.createException("class parameter (" + converterClass.getName() + ") is not a TypeConverter", pElement);
        }
        try {
            Constructor<?> constructor = converterClass.getConstructor(ValueModel.class);
            typeConverter = (TypeConverter)constructor.newInstance(trigger);
        }
        catch (Exception e) {
            throw SwingXMLBuilder.createException("Could not instantiate type converter " + converterClass.getName(), e, pElement);
        }
        return typeConverter;
    }

    private Object createFormatConverter(Element pElement, String pId, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        Format format;
        if (pId == null) {
            throw SwingXMLBuilder.createException("id of " + pElement.getName() + " must not be null", pElement);
        }
        String triggerId = pElement.getAttributeValue("trigger");
        Object trigger = pBuilder.getNonVisualObject(triggerId);
        boolean invert = "true".equals(pElement.getAttributeValue("invert"));
        if (!(trigger instanceof ValueModel)) {
            throw SwingXMLBuilder.createException("no trigger found for " + triggerId, pElement);
        }
        Class<?> formatClass = SwingXMLBuilder.getClass(pElement);
        if (!Format.class.isAssignableFrom(formatClass)) {
            throw SwingXMLBuilder.createException("class parameter (" + formatClass.getClass().getName() + ") is not a Format", pElement);
        }
        String formatString = pElement.getAttributeValue("format");
        if (formatString == null) {
            try {
                format = (Format)formatClass.newInstance();
            }
            catch (Exception e) {
                throw SwingXMLBuilder.createException("Could not instantiate Format " + formatClass.getClass().getName(), e, pElement);
            }
        }
        try {
            Constructor<?> constructor = formatClass.getConstructor(String.class);
            format = (Format)constructor.newInstance(formatString);
        }
        catch (Exception e) {
            throw SwingXMLBuilder.createException("Could not instantiate Format " + formatClass.getClass().getName() + " with format " + formatString, e, pElement);
        }
        return new FormatConverter((ValueModel)trigger, format, invert);
    }

    private Object createRegexpConverter(Element pElement, String pId, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        if (pId == null) {
            throw SwingXMLBuilder.createException("id of " + pElement.getName() + " must not be null", pElement);
        }
        String triggerId = pElement.getAttributeValue("trigger");
        Object trigger = pBuilder.getNonVisualObject(triggerId);
        String blockValue = pElement.getAttributeValue("block");
        if (!(trigger instanceof ValueModel)) {
            throw SwingXMLBuilder.createException("no trigger found for " + triggerId, pElement);
        }
        String formatString = pElement.getAttributeValue("format");
        if (formatString == null) {
            throw SwingXMLBuilder.createException("no regexp found for " + triggerId, pElement);
        }
        try {
            if (blockValue == null) {
                return new RegExpConverter((ValueModel)trigger, formatString);
            }
            boolean block = "true".equals(blockValue);
            return new RegExpConverter((ValueModel)trigger, formatString, block);
        }
        catch (Exception e) {
            throw SwingXMLBuilder.createException("Could not instantiate RegExpConverter  with regular expression " + formatString, e, pElement);
        }
    }

    private Object createConverterInSync(Element pElement, String pId, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        if (pId == null) {
            throw SwingXMLBuilder.createException("id of " + pElement.getName() + " must not be null", pElement);
        }
        String triggerId = pElement.getAttributeValue("ref");
        ValueModel<?> trigger = this.getValueModel(pElement, triggerId, pBuilder);
        if (!(trigger instanceof TypeConverter)) {
            throw SwingXMLBuilder.createException("no TypeConverter found for " + triggerId, pElement);
        }
        ValueModel<Boolean> converterInSync = ((TypeConverter)trigger).getSyncState();
        return converterInSync;
    }

    private Object createSelectionInList(Element pElement, String pId, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        if (pId == null) {
            throw SwingXMLBuilder.createException("id of " + pElement.getName() + " must not be null", pElement);
        }
        String modelref = pElement.getAttributeValue("modelref");
        Object listholder = pBuilder.getNonVisualObject(modelref);
        if (!(listholder instanceof ValueModel)) {
            throw SwingXMLBuilder.createException("not a ValueModel found for " + modelref, pElement);
        }
        return new SelectionInList((ValueModel)listholder);
    }

    private Object createMultiSelectionInList(Element pElement, String pId, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        if (pId == null) {
            throw SwingXMLBuilder.createException("id of " + pElement.getName() + " must not be null", pElement);
        }
        String modelref = pElement.getAttributeValue("modelref");
        Object listholder = pBuilder.getNonVisualObject(modelref);
        if (!(listholder instanceof ValueModel)) {
            throw SwingXMLBuilder.createException("not a ValueModel found for " + modelref, pElement);
        }
        return new MultiSelectionInList((ValueModel)listholder);
    }

    private void setValue(Element pElement, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        Object value;
        String className = pElement.getAttributeValue("class");
        String booleanValue = pElement.getAttributeValue("boolean");
        if (className != null) {
            try {
                value = Class.forName(className).newInstance();
            }
            catch (Exception e) {
                throw SwingXMLBuilder.createException("Could not instantiate a object from " + className, e, pElement);
            }
        } else {
            value = booleanValue != null ? Boolean.valueOf(booleanValue) : pElement.getText();
        }
        String modelRef = pElement.getAttributeValue("modelref");
        String ref = pElement.getAttributeValue("ref");
        String access = pElement.getAttributeValue("access");
        if (modelRef == null && ref == null || modelRef != null && ref != null) {
            throw SwingXMLBuilder.createException("setvalue must have either a modelref attribute or a ref attribute", pElement);
        }
        if (modelRef != null) {
            ValueModel<?> valueModel = this.getValueModel(pElement, modelRef, pBuilder);
            valueModel.setObjectValue(value);
        } else {
            Object target = pBuilder.getNonVisualObject(ref);
            if (target == null) {
                throw SwingXMLBuilder.createException("Could not find a nonvisual object with id " + ref, pElement);
            }
            if (access == null) {
                throw SwingXMLBuilder.createException("attribute access required with ref");
            }
            MixedAccessAdapter accessAdapter = new MixedAccessAdapter(access);
            accessAdapter.setValue(target, value);
        }
    }

    private Object createDocumentAdapter(Element pElement, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        String modelRef = pElement.getAttributeValue("modelref");
        ValueModel<String> valueModel = this.getValueModel(pElement, modelRef, pBuilder);
        String textComponentName = pElement.getAttributeValue("widgetref");
        JComponent textComponent = pBuilder.getComponentByAnyName(textComponentName);
        if (!(textComponent instanceof JTextComponent)) {
            throw SwingXMLBuilder.createException("no JTextComponent found for " + textComponentName, pElement);
        }
        return new DocumentAdapter(valueModel, (JTextComponent)textComponent);
    }

    private Object createButtonAdapter(Element pElement, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        String modelRef = pElement.getAttributeValue("modelref");
        ValueModel<?> valueModel = this.getValueModel(pElement, modelRef, pBuilder);
        String buttonComponentName = pElement.getAttributeValue("widgetref");
        JComponent buttonComponent = pBuilder.getComponentByAnyName(buttonComponentName);
        String invert = pElement.getAttributeValue("invert");
        if (!(buttonComponent instanceof AbstractButton)) {
            throw SwingXMLBuilder.createException("no AbstractButton found for " + buttonComponentName, pElement);
        }
        return new ButtonModelAdapter(valueModel, ((AbstractButton)buttonComponent).getModel(), "true".equals(invert));
    }

    private Object createComboboxAdapter(Element pElement, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        String modelRef = pElement.getAttributeValue("modelref");
        ValueModel<Integer> valueModel = this.getValueModel(pElement, modelRef, pBuilder);
        String comboboxComponentName = pElement.getAttributeValue("widgetref");
        JComponent comboboxComponent = pBuilder.getComponentByAnyName(comboboxComponentName);
        if (!(comboboxComponent instanceof JComboBox)) {
            throw SwingXMLBuilder.createException("no JComboBox found for " + comboboxComponentName, pElement);
        }
        return new ComboBoxModelAdapter(valueModel, ((JComboBox)comboboxComponent).getModel());
    }

    private Object createListAdapter(Element pElement, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        String listComponentName;
        JComponent listComponent;
        String modelRef = pElement.getAttributeValue("modelref");
        ValueModel<?> selectionValueModel = this.getValueModel(pElement, modelRef, pBuilder);
        String accessRef = pElement.getAttributeValue("accessref");
        DelegateAccess accessValueModel = null;
        if (accessRef != null) {
            accessValueModel = this.getDelegateAccess(pElement, accessRef, pBuilder);
        }
        if ((listComponent = pBuilder.getComponentByAnyName(listComponentName = pElement.getAttributeValue("widgetref"))) instanceof JList) {
            if (selectionValueModel instanceof SelectionInList) {
                return new ListModelAdapter((JList)listComponent, (SelectionInList)selectionValueModel, accessValueModel);
            }
            if (selectionValueModel instanceof MultiSelectionInList) {
                return new MultiSelectionListModelAdapter((JList)listComponent, (MultiSelectionInList)selectionValueModel, accessValueModel);
            }
            throw SwingXMLBuilder.createException("no SelectionInList or MultiSelectionInList ValueModel found for " + modelRef, pElement);
        }
        if (listComponent instanceof JComboBox) {
            if (!(selectionValueModel instanceof SelectionInList)) {
                throw SwingXMLBuilder.createException("no SelectionInList ValueModel found for " + modelRef, pElement);
            }
            return new ListModelAdapter((JComboBox)listComponent, (SelectionInList)selectionValueModel, accessValueModel);
        }
        throw SwingXMLBuilder.createException("no JList or JComboBox found for " + listComponentName, pElement);
    }

    private Object createFilteringListAdapter(Element pElement, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        String listComponentName;
        JComponent listComponent;
        String modelRef = pElement.getAttributeValue("modelref");
        ValueModel<?> selectionValueModel = this.getValueModel(pElement, modelRef, pBuilder);
        String accessRef = pElement.getAttributeValue("accessref");
        DelegateAccess accessValueModel = null;
        if (accessRef != null) {
            accessValueModel = this.getDelegateAccess(pElement, accessRef, pBuilder);
        }
        if ((listComponent = pBuilder.getComponentByAnyName(listComponentName = pElement.getAttributeValue("widgetref"))) instanceof JComboBox) {
            if (!(selectionValueModel instanceof SelectionInList)) {
                throw SwingXMLBuilder.createException("no SelectionInList ValueModel found for " + modelRef, pElement);
            }
            selectionValueModel.setValue(new ArrayList());
            return new FilteringListModelAdapter((JComboBox)listComponent, (SelectionInList)selectionValueModel, accessValueModel);
        }
        throw SwingXMLBuilder.createException("no JComboBox found for " + listComponentName, pElement);
    }

    private Object createTableAdapter(Element pElement, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        TableModel back;
        String modelRef = pElement.getAttributeValue("modelref");
        ValueModel<?> valueModel = this.getValueModel(pElement, modelRef, pBuilder);
        String tableName = pElement.getAttributeValue("widgetref");
        JComponent table = pBuilder.getComponentByAnyName(tableName);
        if (!(table instanceof JTable)) {
            throw SwingXMLBuilder.createException("no JTable found for " + tableName, pElement);
        }
        Class<?> listEntryClass = SwingXMLBuilder.getClass(pElement);
        if (listEntryClass != null) {
            TableSelectionModel tableSelectionModel;
            if (!(valueModel instanceof SelectionInList)) {
                throw SwingXMLBuilder.createException("no ValueModel of type SelectionInList found for " + modelRef, pElement);
            }
            boolean sortable = "true".equals(pElement.getAttributeValue("sortable"));
            List<Element> mappingElements = pElement.getChildren("column");
            ArrayList<TableSelectionModel.Mapping> mappings = new ArrayList<TableSelectionModel.Mapping>(mappingElements.size());
            for (Element element : mappingElements) {
                StringBuilder errorInfo = new StringBuilder();
                try {
                    String attributName = element.getAttributeValue("access");
                    errorInfo.append("\nattributName :").append(attributName);
                    String isEditable = element.getAttributeValue("editable");
                    errorInfo.append("\nisEditable :").append(isEditable);
                    String columnTitle = pBuilder.getTitle(element);
                    errorInfo.append("\ncolumnTitle :").append(columnTitle);
                    String columnAlignment = element.getAttributeValue("align");
                    errorInfo.append("\ncolumnAlignment :").append(columnAlignment);
                    Class<?> columnClass = SwingXMLBuilder.getClass(element);
                    errorInfo.append("\ncolumnClass :").append(columnClass);
                    TableSelectionModel.Mapping mapping = new TableSelectionModel.Mapping(attributName, Boolean.valueOf(isEditable), columnTitle, columnAlignment, columnClass);
                    mappings.add(mapping);
                }
                catch (Exception e) {
                    throw SwingXMLBuilder.createException("could not read mapping for the tableadapter" + errorInfo.toString(), e, element);
                }
            }
            back = tableSelectionModel = new TableSelectionModel((JTable)table, (SelectionInList)valueModel, listEntryClass, mappings, sortable);
        } else {
            if (!(valueModel instanceof SelectionInList) && !(valueModel instanceof MultiSelectionInList)) {
                throw SwingXMLBuilder.createException("no ValueModel of type SelectionInList or MultiSelectionInList found for " + modelRef, pElement);
            }
            boolean sortable = "true".equals(pElement.getAttributeValue("sortable"));
            List<Element> mappingElements = pElement.getChildren("column");
            ArrayList<ListTableMapper.Mapping> mappings = new ArrayList<ListTableMapper.Mapping>(mappingElements.size());
            for (Element element : mappingElements) {
                try {
                    String columnTitle = pBuilder.getTitle(element);
                    String columnAlignment = element.getAttributeValue("align");
                    Class<?> columnClass = SwingXMLBuilder.getClass(element);
                    String columnPrefWidth = element.getAttributeValue("prefwidth");
                    String columnModelRef = element.getAttributeValue("modelref");
                    DelegateAccess columnValueModel = this.getDelegateAccess(element, columnModelRef, pBuilder);
                    String columnModelSortRef = element.getAttributeValue("modelref");
                    DelegateAccess columnValueModelSort = (DelegateAccess)pBuilder.getNonVisualObject(columnModelSortRef);
                    boolean columnSortable = "true".equals(element.getAttributeValue("sortable"));
                    String columnComparatorClass = element.getAttributeValue("comparatorclass");
                    ListTableMapper.Mapping mapping = new ListTableMapper.Mapping(columnTitle, columnAlignment, columnPrefWidth, columnClass, columnValueModel, columnValueModelSort, columnSortable, columnComparatorClass);
                    mappings.add(mapping);
                }
                catch (Exception e) {
                    throw SwingXMLBuilder.createException("could not read mapping for the tableadapter", e, element);
                }
            }
            String columnInitialSorting = pElement.getAttributeValue("initialsortingcolumn");
            int columnForInitialSorting = -1;
            try {
                columnForInitialSorting = Integer.parseInt(columnInitialSorting);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (valueModel instanceof SelectionInList) {
                ListTableMapper listTableMapper = new ListTableMapper((JTable)table, (SelectionInList)valueModel, mappings, sortable, columnForInitialSorting);
                back = listTableMapper;
            } else {
                MultiSelectionTableModelAdapter multiListTableAdapter = new MultiSelectionTableModelAdapter((JTable)table, (MultiSelectionInList)valueModel, mappings, sortable, columnForInitialSorting);
                back = multiListTableAdapter;
            }
        }
        return back;
    }

    private void createListener(Element pElement, SwingXMLBuilder pBuilder) {
        String source = pElement.getAttributeValue("source");
        ValueModel<?> valueModel = this.getValueModel(pElement, source, pBuilder);
        String targetName = pElement.getAttributeValue("target");
        Object target = pBuilder.getNonVisualObject(targetName);
        String methodName = pElement.getAttributeValue("method");
        if (target == null) {
            throw SwingXMLBuilder.createException("no target object found for " + targetName, pElement);
        }
        valueModel.onChangeSend(target, methodName);
    }

    private Object createLOVMapper(Element pElement, SwingXMLBuilder pBuilder) {
        String lovsRef = pElement.getAttributeValue("lovsref");
        ValueModel<List<?>[]> lofsHolder = this.getValueModel(pElement, lovsRef, pBuilder);
        String modelRef = pElement.getAttributeValue("modelref");
        ValueModel<?> domainVM = this.getValueModel(pElement, modelRef, pBuilder);
        return new LOVMapper(lofsHolder, domainVM);
    }

    private Object createToolTipAdapter(Element pElement, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        String modelRef = pElement.getAttributeValue("modelref");
        ValueModel<?> valueModel = this.getValueModel(pElement, modelRef, pBuilder);
        String componentName = pElement.getAttributeValue("widgetref");
        JComponent component = pBuilder.getComponentByAnyName(componentName);
        if (!(component instanceof JComponent)) {
            throw SwingXMLBuilder.createException("no JComponent found for " + componentName, pElement);
        }
        return new ToolTipAdapter(valueModel, component);
    }

    private Object createLabelAdapter(Element pElement, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        String modelRef = pElement.getAttributeValue("modelref");
        ValueModel<?> valueModel = this.getValueModel(pElement, modelRef, pBuilder);
        String labelName = pElement.getAttributeValue("widgetref");
        JComponent label = pBuilder.getComponentByAnyName(labelName);
        if (!(label instanceof JLabel)) {
            throw SwingXMLBuilder.createException("no JLabel found for " + labelName, pElement);
        }
        return new LabelAdapter(valueModel, (JLabel)label);
    }

    private Object createLOVAdapter(Element pElement, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        boolean useVMs;
        String modelRef = pElement.getAttributeValue("modelref");
        ValueModel<?> valueModel = this.getValueModel(pElement, modelRef, pBuilder);
        String widgetName = pElement.getAttributeValue("widgetref");
        JComponent widget = pBuilder.getComponentByAnyName(widgetName);
        if (!(widget instanceof JComboBox) && !(widget instanceof JList)) {
            if (widget == null) {
                throw SwingXMLBuilder.createException("no JComboBox/JList/ButtonGroup found for " + widgetName, pElement);
            }
            Object buttonGroup = widget.getClientProperty("buttongroup");
            if (!(buttonGroup instanceof ButtonGroup)) {
                throw SwingXMLBuilder.createException("no JComboBox/JList/ButtonGroup found for " + widgetName, pElement);
            }
        }
        String itemsRef = pElement.getAttributeValue("itemsref");
        String keysRef = pElement.getAttributeValue("keysref");
        String items = pElement.getAttributeValue("items");
        String keys = pElement.getAttributeValue("keys");
        List itemList = null;
        List keyList = null;
        ValueModel<List<?>> itemsVM = null;
        ValueModel<List<?>> keysVM = null;
        if (itemsRef == null && keysRef == null && items != null && keys != null) {
            Object itemL = pBuilder.getNonVisualObject(items);
            if (!(itemL instanceof List)) {
                throw SwingXMLBuilder.createException("no item List found for " + items, pElement);
            }
            Object keyL = pBuilder.getNonVisualObject(keys);
            if (!(keyL instanceof List)) {
                throw SwingXMLBuilder.createException("no key List found for " + keys, pElement);
            }
            useVMs = false;
            itemList = (List)itemL;
            keyList = (List)keyL;
        } else if (itemsRef != null && keysRef != null && items == null && keys == null) {
            useVMs = true;
            itemsVM = this.getValueModel(pElement, itemsRef, pBuilder);
            keysVM = this.getValueModel(pElement, keysRef, pBuilder);
        } else {
            throw SwingXMLBuilder.createException("either the itemsref/keysref or the items/keys attributes must be used", pElement);
        }
        Object unselected = pBuilder.getNonVisualObject(pElement.getAttributeValue("unselected"));
        if (widget instanceof JComboBox) {
            if (useVMs) {
                return new LOVAdapter((JComboBox)widget, itemsVM, keysVM, valueModel, unselected);
            }
            return new LOVAdapter((JComboBox)widget, itemList, keyList, valueModel, unselected);
        }
        if (widget instanceof JList) {
            if (useVMs) {
                return new LOVAdapter((JList)widget, itemsVM, keysVM, valueModel, unselected);
            }
            return new LOVAdapter((JList)widget, itemList, keyList, valueModel, unselected);
        }
        ButtonGroup buttongroup = (ButtonGroup)widget.getClientProperty("buttongroup");
        if (useVMs) {
            return new LOVAdapter(buttongroup, itemsVM, keysVM, valueModel, unselected);
        }
        return new LOVAdapter(buttongroup, itemList, keyList, valueModel, unselected);
    }

    private DelegateAccess getDelegateAccess(Element pElement, String pId, SwingXMLBuilder pBuilder) {
        if (pId == null) {
            throw SwingXMLBuilder.createException("value model id of " + pElement.getName() + " must not be null", pElement);
        }
        Object delegateAccess = pBuilder.getNonVisualObject(pId);
        if (!(delegateAccess instanceof DelegateAccess)) {
            throw SwingXMLBuilder.createException("The accessref '" + pId + "' is no 'DelegateAccess' type", pElement);
        }
        return (DelegateAccess)delegateAccess;
    }

    private ValueModel<?> getValueModel(Element pElement, String pId, SwingXMLBuilder pBuilder) {
        if (pId == null) {
            throw SwingXMLBuilder.createException("value model id of " + pElement.getName() + " must not be null", pElement);
        }
        if (pId.endsWith(SELECTION_HOLDER)) {
            String baseVM = pId.substring(0, pId.lastIndexOf(SELECTION_HOLDER));
            ValueModel<?> vm = this.getValueModel(pElement, baseVM, pBuilder);
            if (!(vm instanceof SelectionInList)) {
                throw SwingXMLBuilder.createException(baseVM + "is no SelectionInList", pElement);
            }
            return ((SelectionInList)vm).selectionHolder();
        }
        if (pId.endsWith(IS_INDEX_IN_LIST_HOLDER)) {
            String baseVM = pId.substring(0, pId.lastIndexOf(IS_INDEX_IN_LIST_HOLDER));
            ValueModel<?> vm = this.getValueModel(pElement, baseVM, pBuilder);
            if (!(vm instanceof SelectionInList)) {
                throw SwingXMLBuilder.createException(baseVM + "is no SelectionInList", pElement);
            }
            return ((SelectionInList)vm).isIndexInList();
        }
        if (pId.endsWith(LIST_HOLDER)) {
            String baseVM = pId.substring(0, pId.lastIndexOf(LIST_HOLDER));
            ValueModel<?> vm = this.getValueModel(pElement, baseVM, pBuilder);
            if (!(vm instanceof SelectionInList)) {
                throw SwingXMLBuilder.createException(baseVM + "is no SelectionInList", pElement);
            }
            return ((SelectionInList)vm).listHolder();
        }
        Object valueModel = pBuilder.getNonVisualObject(pId);
        if (!(valueModel instanceof ValueModel)) {
            throw SwingXMLBuilder.createException("no ValueModel found for " + pId, pElement);
        }
        return (ValueModel)valueModel;
    }
}

