/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import net.sf.cuf.ui.builder.IconCache;

public class SwingDecoratorFunctionality {
    private MultiResourceBundle mMultiBundle;
    private IconCache mIconCache;
    private boolean mEnforceGetString;

    public SwingDecoratorFunctionality() {
        this(true, null);
    }

    public SwingDecoratorFunctionality(boolean pEnforceSet, IconCache pIconCache) {
        if (pIconCache == null) {
            pIconCache = new IconCache();
        }
        this.mMultiBundle = new MultiResourceBundle();
        this.mIconCache = pIconCache;
        this.mEnforceGetString = pEnforceSet;
    }

    public void addBundle(String pBaseName) {
        this.mMultiBundle.addBundle(pBaseName);
    }

    public void addBundle(ResourceBundle pResourceBundle) {
        this.mMultiBundle.addBundle(pResourceBundle);
    }

    public String getText(String pI18nID) {
        return this.getText(pI18nID, null);
    }

    public String getText(String pI18nID, Object[] pParams) {
        String key = pI18nID + ".text";
        return this.getString(key, pI18nID, pParams);
    }

    public String getToolTip(String pI18nID, Object[] pParams) {
        String key = pI18nID + ".tooltip";
        return this.getString(key, pI18nID, pParams);
    }

    public String getTitle(String pI18nID) {
        return this.getTitle(pI18nID, null);
    }

    public String getTitle(String pI18nID, Object[] pParams) {
        String key = pI18nID + ".title";
        return this.getString(key, pI18nID, pParams);
    }

    private String getString(String pKey, String pI18nID, Object[] pParams) {
        if (!this.mMultiBundle.containsKey(pKey)) {
            if (this.mEnforceGetString) {
                return pI18nID;
            }
            return null;
        }
        String value = this.mMultiBundle.getValue(pKey);
        if (pParams == null) {
            return value;
        }
        return MessageFormat.format(value, pParams);
    }

    public Character getMnemonic(String pI18nID) {
        String key = pI18nID + ".mnemonic";
        if (!this.mMultiBundle.containsKey(key)) {
            return null;
        }
        String value = this.mMultiBundle.getValue(key);
        if (value.length() > 0) {
            return Character.valueOf(value.charAt(0));
        }
        return null;
    }

    public KeyStroke getAccelerator(String pI18nID) {
        String key = pI18nID + ".accelerator";
        if (!this.mMultiBundle.containsKey(key)) {
            return null;
        }
        KeyStroke back = null;
        String value = this.mMultiBundle.getValue(key);
        if (value.length() == 1) {
            back = KeyStroke.getKeyStroke("control " + Character.toUpperCase(value.charAt(0)));
        } else if ("F".equalsIgnoreCase(value.substring(0, 1))) {
            back = KeyStroke.getKeyStroke(value);
        }
        return back;
    }

    public Icon getIcon(String pI18nID) {
        return this.getIcon(pI18nID, "");
    }

    public ImageIcon getIcon(String pI18nID, String pIconModifier) {
        return this.mIconCache.getIcon(pI18nID, pIconModifier);
    }

    public void initialize(Action pAction, String pI18nID) {
        String name = this.getText(pI18nID);
        KeyStroke accelerator = this.getAccelerator(pI18nID);
        Character mnemonic = this.getMnemonic(pI18nID);
        String tooltip = this.getToolTip(pI18nID, null);
        Icon icon = this.getIcon(pI18nID);
        if (name != null) {
            pAction.putValue("Name", name);
        }
        if (accelerator != null) {
            pAction.putValue("AcceleratorKey", accelerator);
        }
        if (mnemonic != null) {
            pAction.putValue("MnemonicKey", Character.toUpperCase(mnemonic.charValue()));
        }
        if (tooltip != null) {
            pAction.putValue("ShortDescription", tooltip);
        }
        if (icon != null) {
            pAction.putValue("SmallIcon", icon);
        }
    }

    public void initialize(Component pComponent, String pI18nID) {
        this.initialize(pComponent, pI18nID, null);
    }

    public void initialize(Component pComponent, String pI18nID, Object[] pParams) {
        if (pComponent instanceof JDialog) {
            this.initialize((JDialog)pComponent, pI18nID, pParams);
        } else if (pComponent instanceof JFrame) {
            this.initialize((JFrame)pComponent, pI18nID, pParams);
        } else if (pComponent instanceof JMenuItem) {
            this.initialize((JMenuItem)pComponent, pI18nID, pParams);
        } else if (pComponent instanceof AbstractButton) {
            this.initialize((AbstractButton)pComponent, pI18nID, pParams);
        } else if (pComponent instanceof JLabel) {
            this.initialize((JLabel)pComponent, pI18nID, pParams);
        } else if (pComponent instanceof JTextComponent) {
            this.initialize((JTextComponent)pComponent, pI18nID, pParams);
        } else if (pComponent instanceof JPanel) {
            this.initialize((JPanel)pComponent, pI18nID, pParams);
        } else if (pComponent instanceof JComponent) {
            this.initialize((JComponent)pComponent, pI18nID, pParams);
        }
    }

    private void initialize(JDialog pDialog, String pI18nID, Object[] pParams) {
        String title = this.getTitle(pI18nID, pParams);
        if (title != null) {
            pDialog.setTitle(title);
        }
    }

    private void initialize(JFrame pFrame, String pI18nID, Object[] pParams) {
        ImageIcon imageIcon;
        String title = this.getTitle(pI18nID, pParams);
        if (title != null) {
            pFrame.setTitle(title);
        }
        if ((imageIcon = this.getIcon(pI18nID, "Small")) != null) {
            pFrame.setIconImage(imageIcon.getImage());
        }
    }

    private void initialize(JMenuItem pMenuItem, String pI18nID, Object[] pParams) {
        KeyStroke accelerator;
        String toolTipText;
        Character mnemonic;
        String text;
        ImageIcon imageIcon = this.getIcon(pI18nID, "Small");
        if (imageIcon != null) {
            pMenuItem.setIcon(imageIcon);
        }
        if ((text = this.getText(pI18nID, pParams)) != null) {
            pMenuItem.setText(text);
        }
        if ((mnemonic = this.getMnemonic(pI18nID)) != null) {
            pMenuItem.setMnemonic(mnemonic.charValue());
        }
        if ((toolTipText = this.getToolTip(pI18nID, pParams)) != null && !toolTipText.equals(pI18nID)) {
            pMenuItem.setToolTipText(toolTipText);
        }
        if ((accelerator = this.getAccelerator(pI18nID)) != null) {
            pMenuItem.setAccelerator(accelerator);
        }
    }

    private void initialize(AbstractButton pButton, String pI18nID, Object[] pParams) {
        String toolTipText;
        Character mnemonic;
        String text;
        ImageIcon iconNormal = this.getIcon(pI18nID, "");
        ImageIcon iconPressed = this.getIcon(pI18nID, "Pressed");
        ImageIcon iconRollover = this.getIcon(pI18nID, "Rollover");
        ImageIcon iconDisabled = this.getIcon(pI18nID, "Disabled");
        if (iconNormal != null) {
            pButton.setIcon(iconNormal);
            pButton.setDisabledIcon(iconDisabled);
            pButton.setPressedIcon(iconPressed);
            if (iconRollover == null) {
                pButton.setRolloverEnabled(false);
            } else {
                pButton.setRolloverEnabled(true);
                pButton.setRolloverIcon(iconRollover);
            }
        }
        if ((text = this.getText(pI18nID, pParams)) != null) {
            pButton.setText(text);
        }
        if ((mnemonic = this.getMnemonic(pI18nID)) != null) {
            pButton.setMnemonic(mnemonic.charValue());
        }
        if ((toolTipText = this.getToolTip(pI18nID, pParams)) != null && !toolTipText.equals(pI18nID)) {
            pButton.setToolTipText(toolTipText);
        }
    }

    private void initialize(JLabel pLabel, String pI18nID, Object[] pParams) {
        String toolTipText;
        Character mnemonic;
        String text;
        ImageIcon imageIcon = this.getIcon(pI18nID, "");
        if (imageIcon != null) {
            pLabel.setIcon(imageIcon);
        }
        if ((text = this.getText(pI18nID, pParams)) != null) {
            pLabel.setText(text);
        }
        if ((mnemonic = this.getMnemonic(pI18nID)) != null) {
            pLabel.setDisplayedMnemonic(mnemonic.charValue());
        }
        if ((toolTipText = this.getToolTip(pI18nID, pParams)) != null && !toolTipText.equals(pI18nID)) {
            pLabel.setToolTipText(toolTipText);
        }
    }

    private void initialize(JTextComponent pTextComponent, String pI18nID, Object[] pParams) {
        String toolTipText;
        String text = this.getText(pI18nID, pParams);
        if (text != null && !text.equals(pI18nID)) {
            pTextComponent.setText(text);
        }
        if ((toolTipText = this.getToolTip(pI18nID, pParams)) != null && !toolTipText.equals(pI18nID)) {
            pTextComponent.setToolTipText(toolTipText);
        }
    }

    private void initialize(JPanel pComponent, String pI18nID, Object[] pParams) {
        String toolTipText;
        String title = this.getTitle(pI18nID, pParams);
        if (title != null) {
            pComponent.setBorder(new TitledBorder(title));
        }
        if ((toolTipText = this.getToolTip(pI18nID, pParams)) != null && !toolTipText.equals(pI18nID)) {
            pComponent.setToolTipText(toolTipText);
        }
    }

    private void initialize(JComponent pComponent, String pI18nID, Object[] pParams) {
        String toolTipText = this.getToolTip(pI18nID, pParams);
        if (toolTipText != null && !toolTipText.equals(pI18nID)) {
            pComponent.setToolTipText(toolTipText);
        }
    }

    public static class MultiResourceBundle {
        private Map<String, String> mMap = new HashMap<String, String>();

        public void addBundle(String pBaseName) {
            ResourceBundle bundle;
            try {
                bundle = ResourceBundle.getBundle(pBaseName);
            }
            catch (MissingResourceException e) {
                System.err.println("SwingDecorator.MultiResourceBundle: could not get bundle " + pBaseName + "\n got exception:\n" + e);
                return;
            }
            this.addBundle(bundle);
        }

        public void addBundle(ResourceBundle pBundle) {
            Enumeration<String> keys = pBundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = null;
                String value = null;
                try {
                    key = keys.nextElement();
                    value = pBundle.getString(key);
                }
                catch (Exception e) {
                    System.err.println("SwingDecorator.MultiResourceBundle: problems evaluating " + value + "\n got (and ignored) exception:\n" + e);
                }
                if (key == null || value == null) continue;
                this.mMap.put(key, value);
            }
        }

        public String getValue(String pKey) {
            String value = this.mMap.get(pKey);
            if (value == null) {
                value = "";
            }
            return value;
        }

        public boolean containsKey(String pKey) {
            return this.mMap.containsKey(pKey);
        }
    }
}

