/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.state.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sf.cuf.state.ui.AbstractSwingState;

public class SwingListSelectionState
extends AbstractSwingState
implements ListSelectionListener,
ActionListener,
TableModelListener,
ListDataListener {
    public static final int NO_SELECTION = -1;
    private ListSelectionModel mListSelectionModel;
    private JComboBox mComboBox;
    private TableModel mTableModel;
    private ListModel mListModel;
    private int mListIndex;
    private boolean mReverseIndex;

    public SwingListSelectionState(JList pList) {
        this(pList, -1);
    }

    public SwingListSelectionState(JList pList, int pIndex) {
        this(pList, pIndex, false);
    }

    public SwingListSelectionState(JList pList, int pIndex, boolean pReverseIndex) {
        if (pList == null) {
            throw new IllegalArgumentException("JList must not be null");
        }
        this.init(pList.getSelectionModel(), pList.getModel(), pIndex, pReverseIndex);
    }

    public SwingListSelectionState(JTable pTable) {
        this(pTable, -1);
    }

    public SwingListSelectionState(JTable pTable, int pIndex) {
        this(pTable, pIndex, false);
    }

    public SwingListSelectionState(JTable pTable, int pIndex, boolean pReverseIndex) {
        if (pTable == null) {
            throw new IllegalArgumentException("JTable must not be null");
        }
        this.init(pTable.getSelectionModel(), pTable.getModel(), pIndex, pReverseIndex);
    }

    public SwingListSelectionState(ListSelectionModel pSelectionModel, int pIndex) {
        this.init(pSelectionModel, pIndex);
    }

    public SwingListSelectionState(JComboBox pComboBox) {
        this(pComboBox, -1);
    }

    public SwingListSelectionState(JComboBox pComboBox, int pIndex) {
        this(pComboBox, pIndex, false);
    }

    public SwingListSelectionState(JComboBox pComboBox, int pIndex, boolean pReverseIndex) {
        if (pComboBox == null) {
            throw new IllegalArgumentException("JComboBox must not be null");
        }
        this.init(pComboBox, pIndex, pReverseIndex);
    }

    private void init(ListSelectionModel pSelectionModel, TableModel pTableModel, int pIndex, boolean pReverseIndex) {
        if (pTableModel == null) {
            throw new IllegalArgumentException("table model must not be null");
        }
        this.mReverseIndex = pReverseIndex;
        this.mTableModel = pTableModel;
        this.init(pSelectionModel, pIndex);
        this.mTableModel.addTableModelListener(this);
    }

    private void init(ListSelectionModel pSelectionModel, ListModel pListModel, int pIndex, boolean pReverseIndex) {
        if (pListModel == null) {
            throw new IllegalArgumentException("list model must not be null");
        }
        this.mReverseIndex = pReverseIndex;
        this.mListModel = pListModel;
        this.init(pSelectionModel, pIndex);
        this.mListModel.addListDataListener(this);
    }

    private void init(ListSelectionModel pSelectionModel, int pIndex) {
        if (pSelectionModel == null) {
            throw new IllegalArgumentException("list selection must not be null");
        }
        this.checkIndex(pIndex);
        this.mListIndex = pIndex;
        this.mListSelectionModel = pSelectionModel;
        this.mComboBox = null;
        this.mIsEnabled = this.getInternalState();
        this.mListSelectionModel.addListSelectionListener(this);
    }

    private void init(JComboBox pComboBox, int pIndex, boolean pReverseIndex) {
        this.checkIndex(pIndex);
        this.mReverseIndex = pReverseIndex;
        this.mListIndex = pIndex;
        this.mListSelectionModel = null;
        this.mComboBox = pComboBox;
        this.mIsEnabled = this.getInternalState();
        this.mComboBox.addActionListener(this);
        this.mComboBox.getModel().addListDataListener(this);
    }

    private void checkIndex(int pIndex) throws IllegalArgumentException {
        if (pIndex < -1) {
            throw new IllegalArgumentException("index must be >= -1");
        }
    }

    public void setCompareContent(int pIndex) {
        this.checkIndex(pIndex);
        this.mListIndex = pIndex;
        this.checkStateChange();
    }

    @Override
    public void valueChanged(ListSelectionEvent pEvent) {
        if (pEvent.getValueIsAdjusting()) {
            return;
        }
        this.checkStateChange();
    }

    @Override
    public void tableChanged(TableModelEvent pEvent) {
        this.checkStateChange();
    }

    @Override
    public void intervalAdded(ListDataEvent pEvent) {
        this.checkStateChange();
    }

    @Override
    public void intervalRemoved(ListDataEvent pEvent) {
        this.checkStateChange();
    }

    @Override
    public void contentsChanged(ListDataEvent pEvent) {
        this.checkStateChange();
    }

    @Override
    public void actionPerformed(ActionEvent pEvent) {
        this.checkStateChange();
    }

    @Override
    protected boolean getInternalState() {
        if (this.mListSelectionModel != null) {
            if (this.mListIndex == -1 && this.mListSelectionModel.isSelectionEmpty()) {
                return true;
            }
            int index = this.calcIndex();
            return index >= 0 && this.mListSelectionModel.isSelectedIndex(index);
        }
        if (this.mListIndex == -1) {
            return -1 == this.mComboBox.getSelectedIndex();
        }
        int index = this.calcIndex();
        return index >= 0 && this.mComboBox.getSelectedIndex() == index;
    }

    private int calcIndex() {
        if (this.mReverseIndex) {
            int size;
            if (this.mComboBox != null) {
                size = this.mComboBox.getModel().getSize();
            } else if (this.mTableModel != null) {
                size = this.mTableModel.getRowCount();
            } else if (this.mListModel != null) {
                size = this.mListModel.getSize();
            } else {
                throw new IllegalStateException("could not calc size for reverse index");
            }
            return size - 1 - this.mListIndex;
        }
        return this.mListIndex;
    }

    @Override
    protected void setReason() {
        this.mReason = this.mListSelectionModel;
    }
}

