/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.state.ui;

import java.awt.Component;
import java.awt.Container;
import javax.swing.Action;
import net.sf.cuf.state.AbstractStateAdapter;
import net.sf.cuf.state.State;

public class SwingEnabledAdapter
extends AbstractStateAdapter {
    private boolean mDeepEnable;

    public SwingEnabledAdapter() {
        this(null, false);
    }

    public SwingEnabledAdapter(State pState) {
        this(pState, false);
    }

    public SwingEnabledAdapter(State pState, boolean pDeepEnable) {
        super(pState);
        this.mDeepEnable = pDeepEnable;
    }

    public void setDeepEnable(boolean pDeepEnable) {
        boolean changed = this.mDeepEnable != pDeepEnable;
        this.mDeepEnable = pDeepEnable;
        if (changed) {
            this.stateChanged(null);
        }
    }

    public boolean isDeepEnable() {
        return this.mDeepEnable;
    }

    @Override
    protected void adjustInitialState(Object pTarget, boolean pEnabled) {
        this.processStateChange(pTarget, pEnabled);
    }

    @Override
    protected void processStateChange(Object pTarget, boolean pEnabled) {
        if (pTarget instanceof Component) {
            Component component = (Component)pTarget;
            this.setEnabled(component, pEnabled);
        } else if (pTarget instanceof Action) {
            Action action = (Action)pTarget;
            action.setEnabled(pEnabled);
        } else {
            throw new IllegalStateException("we cant handle that object:" + pTarget);
        }
    }

    private void setEnabled(Component pComponent, boolean pEnabled) {
        if (this.mDeepEnable && pComponent instanceof Container) {
            Component[] children;
            for (Component child : children = ((Container)pComponent).getComponents()) {
                this.setEnabled(child, pEnabled);
            }
        }
        pComponent.setEnabled(pEnabled);
    }
}

