/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.state;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.cuf.state.AbstractState;
import net.sf.cuf.state.State;
import net.sf.cuf.state.StateExpression;

public class SimpleStateExpression
extends AbstractState
implements StateExpression,
ChangeListener {
    private static final String VALUE = "value";
    private static final String AND = "and";
    private static final String OR = "or";
    private static final String XOR = "xor";
    private List<State> mStates;
    private List<Boolean> mInverts;
    private List<String> mOperations;

    public SimpleStateExpression(State pState) {
        this(pState, false);
    }

    public SimpleStateExpression(State pState, boolean pInvert) {
        this.mIsEnabled = pState.isEnabled();
        this.mIsInitialized = pState.isInitialized();
        if (pInvert) {
            this.mIsEnabled = !this.mIsEnabled;
        }
        this.mStates = new ArrayList<State>();
        this.mOperations = new ArrayList<String>();
        this.mInverts = new ArrayList<Boolean>();
        this.add(pState, pInvert, VALUE);
    }

    @Override
    public boolean isInitialized() {
        this.checkDisposed();
        for (State state : this.mStates) {
            if (state.isInitialized()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void and(State pState) {
        this.and(pState, false);
    }

    @Override
    public void andNot(State pState) {
        this.and(pState, true);
    }

    @Override
    public void and(State pState, boolean pInvert) {
        this.add(pState, pInvert, AND);
        this.checkState(pState);
    }

    @Override
    public void or(State pState) {
        this.or(pState, false);
    }

    @Override
    public void orNot(State pState) {
        this.or(pState, true);
    }

    @Override
    public void or(State pState, boolean pInvert) {
        this.add(pState, pInvert, OR);
        this.checkState(pState);
    }

    @Override
    public void xor(State pState) {
        this.xor(pState, false);
    }

    @Override
    public void xorNot(State pState) {
        this.xor(pState, true);
    }

    @Override
    public void xor(State pState, boolean pInvert) {
        this.add(pState, pInvert, XOR);
        this.checkState(pState);
    }

    private void add(State pState, boolean pInvert, String pOperation) {
        this.checkDisposed();
        if (!this.mStates.contains(pState)) {
            pState.addChangeListener(this);
        }
        this.mStates.add(pState);
        this.mOperations.add(pOperation);
        this.mInverts.add(pInvert);
    }

    @Override
    public void stateChanged(ChangeEvent pChangeEvent) {
        this.checkDisposed();
        Object reason = ((State)pChangeEvent.getSource()).getChangeReason();
        this.checkState(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState(Object pReason) {
        boolean oldState;
        if (!this.isInitialized()) {
            this.mIsInitialized = false;
            return;
        }
        boolean initializedChanged = false;
        if (!this.mIsInitialized) {
            this.mIsInitialized = true;
            initializedChanged = true;
        }
        boolean newState = oldState = this.mIsEnabled;
        for (int i = 0; i < this.mStates.size(); ++i) {
            State state = this.mStates.get(i);
            boolean isEnabled = state.isEnabled();
            Boolean invert = this.mInverts.get(i);
            String operation = this.mOperations.get(i);
            if (invert.booleanValue()) {
                boolean bl = isEnabled = !isEnabled;
            }
            if (operation.equals(VALUE)) {
                newState = isEnabled;
                continue;
            }
            if (operation.equals(AND)) {
                newState = newState && isEnabled;
                continue;
            }
            if (operation.equals(OR)) {
                newState = newState || isEnabled;
                continue;
            }
            if (!operation.equals(XOR)) continue;
            newState ^= isEnabled;
        }
        if (initializedChanged || oldState != newState) {
            this.mIsEnabled = newState;
            this.mReason = pReason;
            try {
                this.fireStateChanged();
            }
            finally {
                this.mReason = null;
            }
        }
    }
}

