/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.ui;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class ColumnAlignmentRenderer
extends DefaultTableCellRenderer {
    public static final String ALIGN_LEFT = "left";
    public static final String ALIGN_RIGHT = "right";
    public static final String ALIGN_CENTER = "center";
    private String mColumnAlignment;

    public ColumnAlignmentRenderer() {
        this((String)null);
    }

    public ColumnAlignmentRenderer(String pColumnAlignment) {
        if (pColumnAlignment == null) {
            pColumnAlignment = ALIGN_LEFT;
        }
        if (!(pColumnAlignment.equals(ALIGN_LEFT) || pColumnAlignment.equals(ALIGN_RIGHT) || pColumnAlignment.equals(ALIGN_CENTER))) {
            throw new IllegalArgumentException("alignment >" + pColumnAlignment + "< invalid");
        }
        this.mColumnAlignment = pColumnAlignment;
    }

    @Override
    public Component getTableCellRendererComponent(JTable pTable, Object pValue, boolean pIsSelected, boolean pHasFocus, int pRow, int pColumn) {
        if (pValue != null && !(pValue instanceof Boolean)) {
            try {
                TableCellRenderer renderer = pTable.getDefaultRenderer(pValue.getClass());
                JLabel compLabel = (JLabel)renderer.getTableCellRendererComponent(pTable, pValue, pIsSelected, pHasFocus, pRow, pColumn);
                if (this.mColumnAlignment.equals(ALIGN_LEFT)) {
                    compLabel.setHorizontalAlignment(2);
                } else if (this.mColumnAlignment.equals(ALIGN_RIGHT)) {
                    compLabel.setHorizontalAlignment(4);
                } else if (this.mColumnAlignment.equals(ALIGN_CENTER)) {
                    compLabel.setHorizontalAlignment(0);
                }
                return compLabel;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        if (pValue != null && pValue instanceof Boolean) {
            try {
                TableCellRenderer renderer = pTable.getDefaultRenderer(pValue.getClass());
                JCheckBox compCheckBox = (JCheckBox)renderer.getTableCellRendererComponent(pTable, pValue, pIsSelected, pHasFocus, pRow, pColumn);
                if (this.mColumnAlignment.equals(ALIGN_CENTER)) {
                    compCheckBox.setHorizontalAlignment(0);
                } else if (this.mColumnAlignment.equals(ALIGN_LEFT)) {
                    compCheckBox.setHorizontalAlignment(2);
                } else if (this.mColumnAlignment.equals(ALIGN_RIGHT)) {
                    compCheckBox.setHorizontalAlignment(4);
                }
                return compCheckBox;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return super.getTableCellRendererComponent(pTable, pValue, pIsSelected, pHasFocus, pRow, pColumn);
    }
}

