/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.converter;

import java.util.ArrayList;
import java.util.List;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.model.converter.AbstractTypeConverter;
import net.sf.cuf.model.converter.ConversionException;

public class ListFilterConverter<T>
extends AbstractTypeConverter<List<T>, List<T>> {
    private Filter<T> mFilter;

    public ListFilterConverter(ValueModel<List<T>> pSubject) {
        this(pSubject, null);
    }

    public ListFilterConverter(ValueModel<List<T>> pSubject, Filter<T> pFilter) {
        super(pSubject);
        this.mFilter = pFilter;
    }

    public Filter<T> getFilter() {
        return this.mFilter;
    }

    public void setFilter(Filter<T> pFilter) {
        this.mFilter = pFilter;
        this.fireStateChanged();
    }

    @Override
    public List<T> convertOwnToSubjectValue(List<T> pOwnValue) throws ConversionException {
        throw new ConversionException("ListFilterConverter is read only", null);
    }

    @Override
    public List<T> convertSubjectToOwnValue(List<T> pSubjectValue) throws ConversionException {
        if (pSubjectValue == null) {
            return null;
        }
        if (this.mFilter == null) {
            return new ArrayList<T>(pSubjectValue);
        }
        ArrayList<T> result = new ArrayList<T>(pSubjectValue.size());
        for (T entry : pSubjectValue) {
            if (!this.mFilter.accept(entry)) continue;
            result.add(entry);
        }
        return result;
    }

    public static interface Filter<T> {
        public boolean accept(T var1);
    }
}

