/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.converter;

import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.model.converter.AbstractTypeConverter;
import net.sf.cuf.model.converter.ConversionException;
import net.sf.cuf.model.converter.TypeConverter;

public class FormatConverter<OwnT, SubjectT>
extends AbstractTypeConverter<OwnT, SubjectT>
implements TypeConverter<OwnT, SubjectT> {
    private Format mFormat;
    private boolean mInvert;

    public FormatConverter(ValueModel<SubjectT> pSubject, Format pFormat, boolean pInvert) {
        super(pSubject, false);
        if (pFormat == null) {
            throw new IllegalArgumentException("format must not be null");
        }
        this.mFormat = pFormat;
        this.mInvert = pInvert;
    }

    public FormatConverter(ValueModel<SubjectT> pSubject, Format pFormat) {
        this(pSubject, pFormat, false);
    }

    @Override
    public OwnT convertSubjectToOwnValue(SubjectT pSubjectValue) throws ConversionException {
        if (this.mInvert) {
            return (OwnT)this.parse(pSubjectValue);
        }
        return (OwnT)this.format(pSubjectValue);
    }

    private Object format(Object pObjectToFormat) throws ConversionException {
        if (pObjectToFormat == null) {
            return null;
        }
        try {
            return this.mFormat.format(pObjectToFormat);
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException("could not parse with format", e);
        }
    }

    @Override
    public SubjectT convertOwnToSubjectValue(OwnT pOwnValue) throws ConversionException {
        if (this.mInvert) {
            return (SubjectT)this.format(pOwnValue);
        }
        return (SubjectT)this.parse(pOwnValue);
    }

    private Object parse(Object pObjectToParse) throws ConversionException {
        String ownValue = "";
        if (pObjectToParse != null) {
            ownValue = pObjectToParse.toString();
        }
        ParsePosition pos = new ParsePosition(0);
        Object subjectValue = this.mFormat.parseObject(ownValue, pos);
        if (pos.getIndex() != ownValue.length()) {
            throw new ConversionException("could not parse with format", new ParseException("Format.parseObject(String) failed", pos.getErrorIndex()).fillInStackTrace());
        }
        return subjectValue;
    }
}

