/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model;

import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.cuf.model.AbstractValueModel;
import net.sf.cuf.model.SelectionInList;
import net.sf.cuf.model.ValueModel;

public class LOVMapper
extends AbstractValueModel<Object> {
    private ValueModel<List<?>[]> mLOVsHolder;
    private ValueModel<?> mSelectedDomainValue;
    private SelectionInList<?> mSIL;
    private boolean mInChange;
    public static final int DOMAIN_INDEX = 0;
    public static final int DISPLAY_INDEX = 1;

    public LOVMapper(ValueModel<List<?>[]> pLOVsHolder, ValueModel<?> pSelectedDomainValue) {
        if (pLOVsHolder == null) {
            throw new IllegalArgumentException("LOV's ValueModel must not be null");
        }
        List<?>[] value = pLOVsHolder.getValue();
        if (value != null && value.length != 2) {
            throw new IllegalArgumentException("LOV's value must either be null or a List[2]");
        }
        if (pSelectedDomainValue == null) {
            throw new IllegalArgumentException("selected domain ValueModel must not be null");
        }
        this.mLOVsHolder = pLOVsHolder;
        this.mSelectedDomainValue = pSelectedDomainValue;
        this.mSIL = null;
        this.mLOVsHolder.onChangeSend(this, "lofsChanged");
        this.mSelectedDomainValue.onChangeSend(this, "domainValueChanged");
    }

    @Override
    public Object getValue() {
        List<?>[] value = this.mLOVsHolder.getValue();
        if (value == null) {
            return null;
        }
        List<?>[] lofs = value;
        return lofs[1];
    }

    @Override
    public void setValue(Object pValue, boolean pIsSetForced) {
        throw new UnsupportedOperationException("a LOVMapper is read-only");
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public void onChangeSend(Object pDependent, String pMethodName) {
        super.onChangeSend(pDependent, pMethodName);
        this.checkAddDependent(pDependent);
    }

    @Override
    public void addChangeListener(ChangeListener pDependent) {
        super.addChangeListener(pDependent);
        this.checkAddDependent(pDependent);
    }

    private void checkAddDependent(Object pDependent) {
        if (pDependent instanceof SelectionInList) {
            if (this.mSIL != null) {
                this.mSIL.retractInterestsFor(this);
            }
            this.mSIL = (SelectionInList)pDependent;
            this.mSIL.selectionHolder().onChangeSend(this, "selectionChanged");
        }
    }

    @Override
    public void retractInterestsFor(Object pDependent) {
        super.retractInterestsFor(pDependent);
        this.checkRemoveDependent(pDependent);
    }

    @Override
    public void removeChangeListener(ChangeListener pDependent) {
        super.removeChangeListener(pDependent);
        this.checkRemoveDependent(pDependent);
    }

    private void checkRemoveDependent(Object pDependent) {
        if (this.mSIL == pDependent) {
            if (this.mSIL != null) {
                this.mSIL.retractInterestsFor(this);
            }
            this.mSIL = null;
        }
    }

    public void lofsChanged(ChangeEvent pEvent) {
        List<?>[] value = this.mLOVsHolder.getValue();
        if (value != null && value.length != 2) {
            throw new IllegalArgumentException("LOV's value must either be null or a List[2]");
        }
        this.fireStateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void domainValueChanged(ChangeEvent pEvent) {
        List<?>[] lovs;
        if (this.mInChange) {
            return;
        }
        Object domainValue = this.mSelectedDomainValue.getValue();
        int index = SelectionInList.NO_SELECTION;
        if (domainValue != null && (lovs = this.mLOVsHolder.getValue()) != null) {
            List<?> keys = lovs[0];
            index = keys.indexOf(domainValue);
        }
        if (this.mSIL != null) {
            try {
                this.mInChange = true;
                this.mSIL.selectionHolder().setValue(index);
            }
            finally {
                this.mInChange = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectionChanged(ChangeEvent pEvent) {
        if (this.mInChange) {
            return;
        }
        int index = this.mSIL.getIndex();
        if (index < 0) {
            this.mSelectedDomainValue.setValue(null);
        } else {
            List<?>[] lovs = this.mLOVsHolder.getValue();
            if (lovs != null) {
                List<?> keys = lovs[0];
                try {
                    this.mInChange = true;
                    this.mSelectedDomainValue.setObjectValue(keys.get(index));
                }
                finally {
                    this.mInChange = false;
                }
            }
        }
    }
}

