/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.cuf.model.ExternalUpdate;
import net.sf.cuf.model.ValueModel;

public abstract class AbstractValueModel<T>
implements ValueModel<T>,
ExternalUpdate {
    private ChangeListener[] mJListeners = EMPTY_CL_LIST;
    private Object[] mSListeners = EMPTY_OBJECT_LIST;
    private Method[] mSMethods = EMPTY_METHOD_LIST;
    private ChangeEvent mChangeEvent;
    private Object[] mChangeArgs;
    private boolean mInSetValue = false;
    private boolean mIsSetForced = false;
    private boolean mIsDisposed = false;
    private String mName = "";
    private static final ChangeListener[] EMPTY_CL_LIST = new ChangeListener[0];
    private static final Object[] EMPTY_OBJECT_LIST = new Object[0];
    private static final Method[] EMPTY_METHOD_LIST = new Method[0];
    private static final Class<?>[] PARAMS = new Class[]{ChangeEvent.class};

    protected AbstractValueModel() {
    }

    @Override
    public void onChangeSend(Object pDependent, String pMethodName) {
        Method method;
        this.checkDisposed();
        if (pDependent == null) {
            throw new IllegalArgumentException("dependent object must not be null");
        }
        if (pMethodName == null) {
            throw new IllegalArgumentException("method name must not be null");
        }
        if (!Modifier.isPublic(pDependent.getClass().getModifiers())) {
            throw new IllegalArgumentException("The class " + pDependent.getClass().getName() + " of the dependent object is not public");
        }
        try {
            method = pDependent.getClass().getMethod(pMethodName, PARAMS);
        }
        catch (NoSuchMethodException e) {
            IllegalArgumentException iae = new IllegalArgumentException("could not extract method " + pMethodName + " of class " + pDependent.getClass().getName() + ": " + e.getMessage());
            iae.initCause(e);
            throw iae;
        }
        int oldLength = this.mSListeners.length;
        for (int i = 0; i < oldLength; ++i) {
            if (this.mSListeners[i] != pDependent) continue;
            this.mSMethods[i] = method;
            return;
        }
        Object[] sListeners = new Object[oldLength + 1];
        Method[] sMethods = new Method[oldLength + 1];
        System.arraycopy(this.mSListeners, 0, sListeners, 0, oldLength);
        System.arraycopy(this.mSMethods, 0, sMethods, 0, oldLength);
        sListeners[oldLength] = pDependent;
        sMethods[oldLength] = method;
        this.mSListeners = sListeners;
        this.mSMethods = sMethods;
    }

    @Override
    public void addChangeListener(ChangeListener pDependent) {
        this.checkDisposed();
        if (pDependent == null) {
            throw new IllegalArgumentException("dependent must not be null");
        }
        int oldLength = this.mJListeners.length;
        for (int i = 0; i < oldLength; ++i) {
            if (this.mJListeners[i] != pDependent) continue;
            return;
        }
        ChangeListener[] jListeners = new ChangeListener[oldLength + 1];
        System.arraycopy(this.mJListeners, 0, jListeners, 0, oldLength);
        jListeners[oldLength] = pDependent;
        this.mJListeners = jListeners;
    }

    @Override
    public void retractInterestsFor(Object pDependent) {
        Object sListener;
        int i;
        this.checkDisposed();
        int oldLength = this.mSListeners.length;
        for (i = 0; i < oldLength && (sListener = this.mSListeners[i]) != pDependent; ++i) {
        }
        if (i == oldLength) {
            return;
        }
        int newLength = oldLength - 1;
        if (newLength < 1) {
            this.mSListeners = EMPTY_OBJECT_LIST;
            this.mSMethods = EMPTY_METHOD_LIST;
        } else {
            Object[] sListeners = new Object[newLength];
            Method[] sMethods = new Method[newLength];
            System.arraycopy(this.mSListeners, 0, sListeners, 0, i);
            System.arraycopy(this.mSListeners, i + 1, sListeners, i, newLength - i);
            System.arraycopy(this.mSMethods, 0, sMethods, 0, i);
            System.arraycopy(this.mSMethods, i + 1, sMethods, i, newLength - i);
            this.mSListeners = sListeners;
            this.mSMethods = sMethods;
        }
    }

    @Override
    public void removeChangeListener(ChangeListener pDependent) {
        ChangeListener jListener;
        int i;
        this.checkDisposed();
        int oldLength = this.mJListeners.length;
        for (i = 0; i < oldLength && (jListener = this.mJListeners[i]) != pDependent; ++i) {
        }
        if (i == oldLength) {
            return;
        }
        int newLength = oldLength - 1;
        if (newLength < 1) {
            this.mJListeners = EMPTY_CL_LIST;
        } else {
            ChangeListener[] jListeners = new ChangeListener[newLength];
            System.arraycopy(this.mJListeners, 0, jListeners, 0, i);
            System.arraycopy(this.mJListeners, i + 1, jListeners, i, newLength - i);
            this.mJListeners = jListeners;
        }
    }

    @Override
    public void dispose() {
        this.mIsDisposed = true;
        this.mJListeners = EMPTY_CL_LIST;
        this.mSListeners = EMPTY_OBJECT_LIST;
        this.mSMethods = EMPTY_METHOD_LIST;
    }

    @Override
    public boolean isDisposed() {
        return this.mIsDisposed;
    }

    protected void checkDisposed() throws IllegalStateException {
        if (this.mIsDisposed) {
            throw new IllegalStateException("value model " + this.mName + " was already disposed");
        }
    }

    @Override
    public List<Object> getDependents() {
        ArrayList<Object> dependents = new ArrayList<Object>(this.mJListeners.length + this.mSListeners.length);
        dependents.addAll(Arrays.asList(this.mJListeners));
        dependents.addAll(Arrays.asList(this.mSListeners));
        return Collections.unmodifiableList(dependents);
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setName(String pName) {
        this.checkDisposed();
        if (pName == null) {
            throw new IllegalArgumentException("the name of a value model must not be null");
        }
        this.mName = pName;
    }

    @Override
    public void setValue(T pValue) {
        this.setValue(pValue, false);
    }

    @Override
    public void setObjectValue(Object pValue) {
        this.setValue(pValue);
    }

    @Override
    public void setValueForced(T pValue) {
        this.setValue(pValue, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalExternalUpdate() {
        this.checkDisposed();
        if (this.isInSetValue()) {
            return;
        }
        this.setInSetValue(false, true);
        try {
            this.fireStateChanged();
        }
        finally {
            this.setInSetValue(false, false);
        }
    }

    protected void fireStateChanged() {
        int i;
        ChangeListener[] jListeners = this.mJListeners;
        Object[] sListeners = this.mSListeners;
        Method[] sMethods = this.mSMethods;
        for (i = jListeners.length - 1; i >= 0; --i) {
            if (this.mChangeEvent == null) {
                this.mChangeEvent = new ChangeEvent(this);
            }
            ChangeListener jListener = jListeners[i];
            jListener.stateChanged(this.mChangeEvent);
        }
        for (i = sListeners.length - 1; i >= 0; --i) {
            if (this.mChangeEvent == null) {
                this.mChangeEvent = new ChangeEvent(this);
            }
            if (this.mChangeArgs == null) {
                this.mChangeArgs = new Object[]{this.mChangeEvent};
            }
            Object sListener = sListeners[i];
            Method sMethod = sMethods[i];
            try {
                sMethod.invoke(sListener, this.mChangeArgs);
                continue;
            }
            catch (IllegalAccessException iae) {
                throw new IllegalArgumentException(iae.getMessage());
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getTargetException();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new IllegalArgumentException(cause != null ? cause.getMessage() : ite.getMessage());
            }
        }
    }

    protected boolean isInSetValue() {
        return this.mInSetValue;
    }

    protected void setInSetValue(boolean pInSetValue, boolean pIsSetForced) {
        this.mInSetValue = pInSetValue;
        this.mIsSetForced = pIsSetForced;
    }

    @Override
    public boolean isSetForced() {
        this.checkDisposed();
        return this.mIsSetForced;
    }

    @Override
    public boolean booleanValue() {
        Object value = this.getValue();
        boolean back = value == null ? false : (value instanceof Boolean ? ((Boolean)value).booleanValue() : Boolean.valueOf(value.toString()).booleanValue());
        return back;
    }

    @Override
    public void setValue(boolean pValue) {
        Boolean value = pValue;
        this.setValue((T)value);
    }

    @Override
    public int intValue() {
        Object value = this.getValue();
        int back = value == null ? 0 : (value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString()));
        return back;
    }

    @Override
    public void setValue(int pValue) {
        Integer value = pValue;
        this.setValue((T)value);
    }

    @Override
    public long longValue() {
        Object value = this.getValue();
        long back = value == null ? 0L : (value instanceof Long ? (Long)value : Long.parseLong(value.toString()));
        return back;
    }

    @Override
    public void setValue(long pValue) {
        Long value = pValue;
        this.setValue((T)value);
    }

    @Override
    public float floatValue() {
        Object value = this.getValue();
        float back = value == null ? 0.0f : (value instanceof Float ? ((Float)value).floatValue() : Float.valueOf(value.toString()).floatValue());
        return back;
    }

    @Override
    public void setValue(float pValue) {
        Float value = Float.valueOf(pValue);
        this.setValue((T)value);
    }

    @Override
    public double doubleValue() {
        Object value = this.getValue();
        double back = value == null ? 0.0 : (value instanceof Double ? ((Double)value).doubleValue() : Double.valueOf(value.toString()).doubleValue());
        return back;
    }

    @Override
    public void setValue(double pValue) {
        Double value = pValue;
        this.setValue((T)value);
    }

    @Override
    public String stringValue() {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

