/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.fw2;

import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import net.sf.cuf.appevent.AppEvent;
import net.sf.cuf.appevent.AppEventSupport;
import net.sf.cuf.appevent.AppEventUtil;
import net.sf.cuf.appevent.BindEvent;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw2.AppPc;
import net.sf.cuf.fw2.BlockEvent;
import net.sf.cuf.fw2.GlassPane;
import net.sf.cuf.fw2.MenuToolBarEvent;
import net.sf.cuf.fw2.ShowStatusEvent;

public abstract class AbstractSwingAppPc
implements AppPc {
    public static final String SEPARATOR = "/";
    protected AppEventSupport mAppEventSupport;
    protected JToolBar mToolBar;
    protected JMenuBar mMenuBar;
    protected Map<String, JMenuItem> mMenuMap = new HashMap<String, JMenuItem>();
    protected Object mFrameOrDialog;
    private GlassPane mGlassPane = new GlassPane();
    private Component mLastFocusOwner;
    protected JLabel mStatusLabel;

    @Override
    public void init(Dc pDc, Map<String, ? super Object> pArgs) {
        this.mAppEventSupport = (AppEventSupport)((Object)pDc);
        BindEvent bindMenuToolBar = new BindEvent(this, "menuToolbarChanged", MenuToolBarEvent.class);
        this.postAppEvent(bindMenuToolBar);
        BindEvent bindBlock = new BindEvent(this, "blockChanged", BlockEvent.class);
        this.postAppEvent(bindBlock);
        BindEvent bindShowStatus = new BindEvent(this, "statusChanged", ShowStatusEvent.class);
        this.postAppEvent(bindShowStatus);
    }

    @Override
    public void postAppEvent(AppEvent pAppEvent) {
        AppEventUtil.postAppEvent(this.mAppEventSupport, pAppEvent);
    }

    public void menuToolbarChanged(MenuToolBarEvent pEvent) {
        boolean delete = pEvent.isDelete();
        if (this.mToolBar != null) {
            List<Component> toolBarButtons = pEvent.getToolBarButtons();
            int n = toolBarButtons.size();
            for (int i = 0; i < n; ++i) {
                Component component = toolBarButtons.get(i);
                if (delete) {
                    this.mToolBar.remove(component);
                } else {
                    this.mToolBar.add(component);
                }
                this.mToolBar.repaint();
            }
        } else if (pEvent.getToolBarButtons().size() > 0) {
            System.err.println("derived class forgot to set our tool bar");
        }
        if (this.mMenuBar != null) {
            Map<String, Integer> insertionMap = pEvent.getMenuInsertionIndeces();
            for (Map.Entry<String, Object> entry : pEvent.getMenus().entrySet()) {
                ArrayList<JMenuItem> menuItems;
                String key = entry.getKey();
                Object value = entry.getValue();
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException("menuItem key is not a string but " + key);
                }
                if (!(value instanceof List) && !(value instanceof JMenuItem)) {
                    throw new IllegalArgumentException("menuItem value is not a List/JMenuItem but " + value + ", the key was " + key);
                }
                String fullParentMenuName = key;
                if (!fullParentMenuName.startsWith(SEPARATOR)) {
                    throw new IllegalArgumentException("menuItem name must start with a /");
                }
                if (value instanceof JMenuItem) {
                    menuItems = new ArrayList<JMenuItem>(1);
                    menuItems.add((JMenuItem)value);
                } else {
                    menuItems = (ArrayList<JMenuItem>)value;
                }
                int n = menuItems.size();
                for (int i = 0; i < n; ++i) {
                    JMenuItem menuItem = (JMenuItem)menuItems.get(i);
                    if (!this.mMenuMap.containsKey(fullParentMenuName) && !fullParentMenuName.equals(SEPARATOR)) {
                        throw new IllegalArgumentException("could not add/delete menuItem for parent " + fullParentMenuName);
                    }
                    if (menuItem instanceof JMenu && menuItem.getName() != null) {
                        String menuName = fullParentMenuName.endsWith(SEPARATOR) ? fullParentMenuName + menuItem.getName() : fullParentMenuName + SEPARATOR + menuItem.getName();
                        if (delete) {
                            this.mMenuMap.remove(menuName);
                        } else {
                            if (this.mMenuMap.containsKey(menuName)) continue;
                            this.mMenuMap.put(menuName, menuItem);
                        }
                    }
                    if (fullParentMenuName.equals(SEPARATOR)) {
                        if (delete) {
                            this.mMenuBar.remove(menuItem);
                        } else {
                            int index = 0;
                            if (insertionMap.containsKey(fullParentMenuName)) {
                                index = insertionMap.get(fullParentMenuName);
                            }
                            if (index > 0) {
                                this.mMenuBar.add((Component)menuItem, --index);
                            } else if (index < 0) {
                                index = this.mMenuBar.getComponentCount() + index + 1;
                                this.mMenuBar.add((Component)menuItem, index);
                            } else {
                                this.mMenuBar.add(menuItem);
                            }
                        }
                        this.mMenuBar.repaint();
                        continue;
                    }
                    JMenu parentMenu = (JMenu)this.mMenuMap.get(fullParentMenuName);
                    if (delete) {
                        parentMenu.remove(menuItem);
                        continue;
                    }
                    int index = 0;
                    if (insertionMap.containsKey(fullParentMenuName)) {
                        index = insertionMap.get(fullParentMenuName);
                    }
                    if (index > 0) {
                        parentMenu.add((Component)menuItem, --index);
                        continue;
                    }
                    if (index < 0) {
                        index = parentMenu.getComponentCount() + index + 1;
                        parentMenu.add((Component)menuItem, index);
                        continue;
                    }
                    parentMenu.add(menuItem);
                }
            }
        } else if (pEvent.getMenus().size() > 0) {
            System.err.println("derived class forgot to set our menu bar");
        }
    }

    public void blockChanged(BlockEvent pEvent) {
        JFrame frame = null;
        JDialog dialog = null;
        if (this.mFrameOrDialog instanceof JFrame) {
            frame = (JFrame)this.mFrameOrDialog;
        } else if (this.mFrameOrDialog instanceof JDialog) {
            dialog = (JDialog)this.mFrameOrDialog;
        }
        if (frame == null && dialog == null) {
            System.err.println("derived class forgot to set our frame/dialog");
            return;
        }
        if (frame != null && frame.getGlassPane() != this.mGlassPane) {
            frame.setGlassPane(this.mGlassPane);
        }
        if (dialog != null && dialog.getGlassPane() != this.mGlassPane) {
            dialog.setGlassPane(this.mGlassPane);
        }
        if (pEvent.isBlock()) {
            this.mGlassPane.setCursor(Cursor.getPredefinedCursor(3));
            this.mGlassPane.setVisible(true);
            this.mLastFocusOwner = frame != null ? frame.getFocusOwner() : dialog.getFocusOwner();
            this.mGlassPane.requestFocus();
        } else {
            this.mGlassPane.setCursor(Cursor.getDefaultCursor());
            this.mGlassPane.setVisible(false);
            if (this.mLastFocusOwner != null) {
                if (this.mLastFocusOwner instanceof JComponent) {
                    if (((JComponent)this.mLastFocusOwner).isRequestFocusEnabled()) {
                        this.mLastFocusOwner.requestFocus();
                    }
                } else if (this.mLastFocusOwner.isEnabled()) {
                    this.mLastFocusOwner.requestFocus();
                }
            }
        }
    }

    public void statusChanged(ShowStatusEvent pEvent) {
        if (this.mStatusLabel != null) {
            this.mStatusLabel.setText(pEvent.getStatusText());
        } else {
            System.err.println("derived class forgot to set our status label");
        }
    }

    @Override
    public void dispose(Map<String, ? super Object> pArgs) {
    }
}

