/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvview.browse;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.sf.cuf.csvview.browse.AbstractLoadRequest;
import net.sf.cuf.csvview.browse.LoadDataRequest;
import net.sf.cuf.csvview.util.CSVTableModel;
import net.sf.cuf.xfer.DefaultResponse;
import net.sf.cuf.xfer.Response;

public class LoadFileRequest
extends AbstractLoadRequest
implements LoadDataRequest {
    private File mFile;

    public LoadFileRequest(File pFile, boolean pFirstRowIsHeader, String pCSVSeparator, String pEncoding) {
        super(pCSVSeparator, pEncoding, pFirstRowIsHeader);
        if (pFile == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        this.mFile = pFile;
    }

    @Override
    public Response execute() {
        DefaultResponse response = new DefaultResponse();
        try {
            FileInputStream input = new FileInputStream(this.mFile);
            CSVTableModel model = new CSVTableModel(input, this.mFirstRowIsHeader, this.mCSVSeparator, this.mEncoding);
            ((InputStream)input).close();
            response.setResult(model);
        }
        catch (Exception e) {
            response.setError(e);
        }
        return response;
    }
}

