/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvview.about;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.Timer;
import net.sf.cuf.csvview.Version;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw.Pc;
import net.sf.cuf.ui.builder.SwingXMLBuilder;

public class AboutPc
implements Pc,
ActionListener,
SwingXMLBuilder.Backlink {
    private SwingXMLBuilder mBuilder;
    private boolean mInFade = false;
    private int mCounter = 256;
    private int mStep = -16;
    private AlphaFilter mFilter;
    private Timer mTimer = new Timer(100, this);
    private ImageIcon mIcon1;
    private ImageIcon mIcon2;
    private ImageIcon mIcon;
    private static final int DELAY = 100;
    private static final int MAX_COUNTER = 256;
    private static final int STEP = 16;

    public AboutPc() {
        this.mFilter = new AlphaFilter();
    }

    public void setSwingXMLBuilder(SwingXMLBuilder pBuilder) {
        this.mBuilder = pBuilder;
    }

    public void init(Dc pDc, Map<String, ? super Object> pArgs) {
        this.mIcon1 = this.mBuilder.getIconCache().getIcon("AboutLogo", "");
        this.mIcon2 = this.mBuilder.getIconCache().getIcon("jzeller", "");
        this.mIcon = this.mIcon1;
        JLabel versionLabel = (JLabel)this.mBuilder.getComponentByName("Frame/AboutDialog/Panel/Version");
        StringBuilder versionText = new StringBuilder(versionLabel.getText());
        versionText.append(", Version ");
        versionText.append(Version.VERSION);
        versionText.append(" (");
        versionText.append(Version.DATE);
        versionText.append(" )");
        versionLabel.setText(versionText.toString());
        JLabel jdkLabel = (JLabel)this.mBuilder.getComponentByName("Frame/AboutDialog/Panel/JDK");
        StringBuilder jdkText = new StringBuilder("Java VM from ");
        jdkText.append(System.getProperty("java.vendor"));
        jdkText.append(", Version ");
        jdkText.append(System.getProperty("java.version"));
        jdkLabel.setText(jdkText.toString());
        JLabel magicLabel = (JLabel)this.mBuilder.getComponentByName("Frame/AboutDialog/Panel/Magic");
        magicLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent pMouseEvent) {
                if (AboutPc.this.mInFade) {
                    return;
                }
                AboutPc.this.mInFade = true;
                AboutPc.this.mCounter = 256;
                AboutPc.this.mStep = -16;
                AboutPc.this.mTimer.start();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent pEvent) {
        JLabel magicLabel = (JLabel)this.mBuilder.getComponentByName("Frame/AboutDialog/Panel/Magic");
        this.mFilter.setLevel(this.mCounter - 1);
        Image image = magicLabel.createImage(new FilteredImageSource(this.mIcon.getImage().getSource(), this.mFilter));
        ImageIcon newIcon = new ImageIcon(image);
        magicLabel.setIcon(newIcon);
        this.mCounter += this.mStep;
        if (this.mCounter <= 0) {
            this.mCounter = 16;
            this.mStep = 16;
            this.mIcon = this.mIcon == this.mIcon1 ? this.mIcon2 : this.mIcon1;
        }
        if (this.mCounter > 256) {
            this.mInFade = false;
            this.mTimer.stop();
        }
    }

    public void about() {
        JDialog aboutDialog = (JDialog)this.mBuilder.getContainerByName("Frame/AboutDialog");
        aboutDialog.setModal(true);
        JButton okButton = (JButton)this.mBuilder.getComponentByName("Frame/AboutDialog/Panel/OK");
        aboutDialog.getRootPane().setDefaultButton(okButton);
        aboutDialog.pack();
        Rectangle parentBounds = aboutDialog.getParent().getBounds();
        int deltaX = (parentBounds.width - aboutDialog.getBounds().width) / 2;
        int deltaY = (parentBounds.height - aboutDialog.getBounds().height) / 2;
        aboutDialog.setLocation(parentBounds.x + deltaX, parentBounds.y + deltaY);
        aboutDialog.setVisible(true);
    }

    public void aboutOK() {
        JLabel magicLabel = (JLabel)this.mBuilder.getComponentByName("Frame/AboutDialog/Panel/Magic");
        this.mIcon = this.mIcon1;
        magicLabel.setIcon(this.mIcon);
        JDialog aboutDialog = (JDialog)this.mBuilder.getContainerByName("Frame/AboutDialog");
        aboutDialog.setVisible(false);
    }

    private static class AlphaFilter
    extends RGBImageFilter {
        private int mLevel;

        public AlphaFilter() {
            this.canFilterIndexColorModel = true;
        }

        public void setLevel(int pLevel) {
            this.mLevel = pLevel;
        }

        @Override
        public int filterRGB(int pX, int pY, int pRGB) {
            return pRGB & 0xFFFFFF | this.mLevel * 0x1000000;
        }
    }
}

