package net.sf.cuf.csvview.util;

import javax.swing.filechooser.FileFilter;
import java.io.File;

/**
 * Filter for the Swing file dialog.
 */
public class EXEFileFilter extends FileFilter
{
    /** our filtered extension */
    private static final String EXE= "exe";

    /**
     * Accept all directories and all csv or txt files.
     * @param pFile file to check
     * @return true if pFile is a file or has a csv/txt suffix.
     */
    public boolean accept(final File pFile)
    {
        if (pFile.isDirectory())
        {
            return true;
        }

        String extension= null;
        String fileName = pFile.getName();
        int i = fileName.lastIndexOf('.');
        if (i > 0 &&  i < fileName.length() - 1)
        {
            extension= fileName.substring(i+1).toLowerCase();
        }
        return (extension != null) &&
               (extension.equalsIgnoreCase(EXE));

    }

    /**
     * Return our description.
     * @return the description
     */
    public String getDescription()
    {
        return "Ausführbare Programme (*.exe)";
    }
}
