/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.builder;

import java.awt.Container;
import java.util.HashMap;
import java.util.Map;
import net.sf.cuf.ui.builder.DefaultWidgetFactory;
import net.sf.cuf.ui.builder.WidgetFactory;
import org.jdom2.Element;

public class WidgetFactoryRegistry
implements WidgetFactory {
    public static final String ALL_TYPES = "allTypes";
    private Map<String, WidgetFactory> mFactoryMap = new HashMap<String, WidgetFactory>();

    @Override
    public Container create(String pType, Element pElement, Container pParent) {
        return this.findValidFactory(pType).create(pType, pElement, pParent);
    }

    @Override
    public void notifyWidgetComplete(String pType, Element pElement, Container pCurrentWidget) {
        this.findValidFactory(pType).notifyWidgetComplete(pType, pElement, pCurrentWidget);
    }

    WidgetFactoryRegistry() {
        this.registerFactory(ALL_TYPES, new DefaultWidgetFactory());
    }

    public void registerFactory(String pType, WidgetFactory pFactory) throws IllegalArgumentException {
        if (ALL_TYPES.equals(pType) && pFactory == null) {
            throw new IllegalArgumentException("default factory (allTypes) must not be null");
        }
        this.mFactoryMap.put(pType, pFactory);
    }

    private WidgetFactory findValidFactory(String pType) {
        WidgetFactory myFactory = this.mFactoryMap.get(pType);
        if (myFactory == null && (myFactory = this.mFactoryMap.get(ALL_TYPES)) == null) {
            throw new IllegalArgumentException("No Registry found for type " + pType.getClass().getName());
        }
        return myFactory;
    }
}

