/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;

public class DispatcherAction
extends AbstractAction {
    public static final String TOGGLE_MODEL = "DispatcherAction_TOGGLE_MODEL";
    protected EventListenerList mListenerList = new EventListenerList();
    protected Object mRealSource;

    public DispatcherAction() {
    }

    public DispatcherAction(String pEntryText, String pEntryAccelerator, String pEntryMnemonic, String pEntryTooltip, Icon pIcon, boolean pIsToggle) {
        this();
        Integer mnemonic = null;
        if (pEntryMnemonic != null && pEntryMnemonic.length() > 0) {
            mnemonic = Character.toUpperCase(pEntryMnemonic.charAt(0));
        }
        KeyStroke keyStroke = null;
        if (pEntryAccelerator != null && pEntryAccelerator.length() > 0) {
            keyStroke = KeyStroke.getKeyStroke(pEntryAccelerator);
        }
        this.putValue("Name", pEntryText);
        this.putValue("AcceleratorKey", keyStroke);
        this.putValue("MnemonicKey", mnemonic);
        this.putValue("ShortDescription", pEntryTooltip);
        this.putValue("SmallIcon", pIcon);
        if (pIsToggle) {
            this.putValue(TOGGLE_MODEL, new JToggleButton.ToggleButtonModel());
        }
    }

    public String getEntryText() {
        return (String)this.getValue("Name");
    }

    public String getEntryAccelerator() {
        KeyStroke keyStroke = (KeyStroke)this.getValue("AcceleratorKey");
        String back = keyStroke == null ? null : new Character(keyStroke.getKeyChar()).toString();
        return back;
    }

    public String getEntryMnemonic() {
        Integer mnemonicKey = (Integer)this.getValue("MnemonicKey");
        String back = mnemonicKey == null ? null : mnemonicKey.toString();
        return back;
    }

    public String getTooltip() {
        return (String)this.getValue("ShortDescription");
    }

    public Icon getEntryIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public boolean isToggle() {
        Object toggleModel = this.getValue(TOGGLE_MODEL);
        return toggleModel != null;
    }

    public ButtonModel getToggleModel() {
        Object toggleModel = this.getValue(TOGGLE_MODEL);
        return (ButtonModel)toggleModel;
    }

    @Override
    public void setEnabled(boolean pNewValue) {
        super.setEnabled(pNewValue);
        if (this.isToggle()) {
            this.getToggleModel().setEnabled(pNewValue);
        }
    }

    public boolean isSelected() {
        ButtonModel model = this.getToggleModel();
        if (model != null) {
            return model.isSelected();
        }
        return false;
    }

    public void setSelected(boolean pSelected) {
        ButtonModel model = this.getToggleModel();
        if (model != null) {
            model.setSelected(pSelected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent pEvent) {
        Object[] listeners = this.mListenerList.getListenerList();
        this.mRealSource = pEvent.getSource();
        pEvent.setSource(this);
        try {
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != ActionListener.class) continue;
                ((ActionListener)listeners[i + 1]).actionPerformed(pEvent);
            }
        }
        finally {
            pEvent.setSource(this.mRealSource);
            this.mRealSource = null;
        }
    }

    public void addActionListener(ActionListener pListener) {
        this.mListenerList.add(ActionListener.class, pListener);
    }

    public void removeActionListener(ActionListener pListener) {
        this.mListenerList.remove(ActionListener.class, pListener);
    }

    public Object getRealSource() {
        return this.mRealSource;
    }
}

