/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.state.ui;

import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import net.sf.cuf.state.State;
import net.sf.cuf.state.ui.AbstractSwingState;

public class SwingTreeModelFillState
extends AbstractSwingState
implements State,
TreeModelListener {
    private TreeModel mTreeModel;
    private boolean mCountRootAsContent;
    private int mThreshold;

    public SwingTreeModelFillState(JTree pTree) {
        this(pTree, false);
    }

    public SwingTreeModelFillState(JTree pTree, boolean pCountRootAsContent) {
        if (pTree == null) {
            throw new IllegalArgumentException("JTree must not be null");
        }
        this.init(pTree.getModel(), pCountRootAsContent, 1);
    }

    public SwingTreeModelFillState(TreeModel pModel, boolean pCountRootAsContent, int pThreshold) {
        this.init(pModel, pCountRootAsContent, pThreshold);
    }

    private void init(TreeModel pModel, boolean pCountRootAsContent, int pThreshold) {
        if (pModel == null) {
            throw new IllegalArgumentException("tree model must not be null");
        }
        this.mCountRootAsContent = pCountRootAsContent;
        this.mTreeModel = pModel;
        this.mThreshold = pThreshold;
        this.mIsEnabled = this.getInternalState();
        this.mTreeModel.addTreeModelListener(this);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent pEvent) {
        this.checkStateChange();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent pEvent) {
        this.checkStateChange();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent pEvent) {
        this.checkStateChange();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent pEvent) {
        this.checkStateChange();
    }

    @Override
    protected boolean getInternalState() {
        Object root = this.mTreeModel.getRoot();
        if (this.mCountRootAsContent) {
            if (root == null) {
                return 0 >= this.mThreshold;
            }
            return 1 + this.mTreeModel.getChildCount(root) >= this.mThreshold;
        }
        return this.mTreeModel.getChildCount(root) >= this.mThreshold;
    }

    @Override
    protected void setReason() {
        this.mReason = this.mTreeModel;
    }
}

