/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.state;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.cuf.state.State;
import net.sf.cuf.state.StateAdapter;

public abstract class AbstractStateAdapter
implements StateAdapter,
ChangeListener {
    private Map<Object, Boolean> mTargets = new HashMap<Object, Boolean>();
    private State mState = null;
    private String mName = "";
    private static final Map<String, List<WeakReference<Object>>> CONSISTENCY_MAP = new HashMap<String, List<WeakReference<Object>>>();

    public AbstractStateAdapter() {
    }

    public AbstractStateAdapter(State pState) {
        this();
        this.setState(pState);
    }

    public AbstractStateAdapter(State pState, String pName) {
        this();
        this.setState(pState);
        this.setName(pName);
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setName(String pName) {
        if (pName == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.mName = pName;
    }

    @Override
    public void setState(State pState) {
        if (this.mState != null) {
            this.mState.removeChangeListener(this);
        }
        this.mState = pState;
        if (this.mState != null) {
            this.mState.addChangeListener(this);
            boolean stateEnabled = this.mState.isEnabled();
            for (Map.Entry<Object, Boolean> nextEntry : this.mTargets.entrySet()) {
                Object target = nextEntry.getKey();
                boolean invert = nextEntry.getValue();
                boolean enabled = invert ? !stateEnabled : stateEnabled;
                this.adjustInitialState(target, enabled);
            }
        }
    }

    @Override
    public void add(Object pTarget) {
        this.add(pTarget, false);
    }

    @Override
    public void addInvert(Object pTarget) {
        this.add(pTarget, true);
    }

    @Override
    public void add(Object pTarget, boolean pInvert) {
        if (pTarget == null) {
            throw new IllegalArgumentException("target must not be null");
        }
        this.checkDuplicateTarget(pTarget);
        boolean enabled = pInvert ? !this.mState.isEnabled() : this.mState.isEnabled();
        this.adjustInitialState(pTarget, enabled);
        this.mTargets.put(pTarget, pInvert ? Boolean.TRUE : Boolean.FALSE);
    }

    private void checkDuplicateTarget(Object pTarget) {
        String category = this.getConsistencyCategory();
        List<WeakReference<Object>> targetList = CONSISTENCY_MAP.get(category);
        if (targetList == null) {
            targetList = new ArrayList<WeakReference<Object>>();
            CONSISTENCY_MAP.put(category, targetList);
            targetList.add(new WeakReference<Object>(pTarget));
            return;
        }
        Iterator<WeakReference<Object>> iter = targetList.iterator();
        while (iter.hasNext()) {
            WeakReference<Object> previousTarget = iter.next();
            if (previousTarget.get() == null) {
                iter.remove();
                continue;
            }
            if (pTarget != previousTarget.get()) continue;
            throw new IllegalArgumentException("target " + pTarget + " is already in use in state adapter category " + category);
        }
        targetList.add(new WeakReference<Object>(pTarget));
    }

    protected String getConsistencyCategory() {
        return this.getClass().getName();
    }

    @Override
    public void remove(Object pComponent) {
        this.mTargets.remove(pComponent);
        String category = this.getConsistencyCategory();
        List<WeakReference<Object>> targetList = CONSISTENCY_MAP.get(category);
        if (targetList == null) {
            return;
        }
        Iterator<WeakReference<Object>> iter = targetList.iterator();
        while (iter.hasNext()) {
            WeakReference<Object> previousTarget = iter.next();
            if (previousTarget.get() == null) {
                iter.remove();
                continue;
            }
            if (pComponent != previousTarget.get()) continue;
            iter.remove();
        }
    }

    @Override
    public void stateChanged(ChangeEvent pEvent) {
        boolean stateEnabled = this.mState.isEnabled();
        for (Map.Entry<Object, Boolean> nextEntry : this.mTargets.entrySet()) {
            Object target = nextEntry.getKey();
            boolean invert = nextEntry.getValue();
            boolean enabled = invert ? !stateEnabled : stateEnabled;
            this.processStateChange(target, enabled);
        }
    }

    protected abstract void adjustInitialState(Object var1, boolean var2);

    protected abstract void processStateChange(Object var1, boolean var2);
}

