/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.ui;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import net.sf.cuf.model.DelegateAccess;
import net.sf.cuf.model.SelectionInList;

public class ListModelAdapter
implements ComboBoxModel,
ListSelectionModel {
    private EventListenerList mListenerList;
    private ListSelectionModel mListSelectionModel;
    private boolean mInSelectionChange;
    protected SelectionInList<?> mSelectionInList;
    private DelegateAccess mAccessValueModel;

    public ListModelAdapter(JList pList, SelectionInList<?> pListValueModel, DelegateAccess pAccessValueModel) {
        if (pList == null) {
            throw new IllegalArgumentException("list must not be null");
        }
        if (pListValueModel == null) {
            throw new IllegalArgumentException("list value model must not be null");
        }
        this.mListSelectionModel = pList.getSelectionModel();
        if (this.mListSelectionModel == null) {
            throw new IllegalArgumentException("list selection model must not be null");
        }
        this.mListSelectionModel.setSelectionMode(0);
        this.mSelectionInList = pListValueModel;
        this.mAccessValueModel = pAccessValueModel;
        this.mListenerList = new EventListenerList();
        this.mInSelectionChange = false;
        this.mSelectionInList.onChangeSend(this, "vmDataChanged");
        this.mSelectionInList.selectionHolder().onChangeSend(this, "vmSelectionChanged");
        pList.setModel(this);
        pList.setSelectionModel(this);
    }

    public ListModelAdapter(JComboBox pComboBox, SelectionInList<?> pListValueModel, DelegateAccess pAccessValueModel) {
        if (pComboBox == null) {
            throw new IllegalArgumentException("combobox must not be null");
        }
        if (pListValueModel == null) {
            throw new IllegalArgumentException("list value model must not be null");
        }
        this.mSelectionInList = pListValueModel;
        this.mAccessValueModel = pAccessValueModel;
        this.mListenerList = new EventListenerList();
        this.mInSelectionChange = false;
        this.mListSelectionModel = new DefaultListSelectionModel();
        this.mListSelectionModel.setSelectionMode(0);
        this.mSelectionInList.onChangeSend(this, "vmDataChanged");
        this.mSelectionInList.selectionHolder().onChangeSend(this, "vmSelectionChanged");
        pComboBox.setModel(this);
    }

    protected void fireListChanged(ListDataEvent pEvent) {
        Object[] listeners = this.mListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ListDataListener.class) continue;
            ((ListDataListener)listeners[i + 1]).contentsChanged(pEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vmDataChanged(ChangeEvent pEvent) {
        int index = this.mSelectionInList.selectionHolder().intValue();
        this.mInSelectionChange = true;
        try {
            Object data = this.mSelectionInList.getValue();
            int size = data == null ? 0 : data.size();
            ListDataEvent e = new ListDataEvent(this, 0, 0, size);
            this.fireListChanged(e);
            if (index < 0 || index >= size) {
                this.mListSelectionModel.clearSelection();
            } else {
                this.mListSelectionModel.setSelectionInterval(index, index);
            }
        }
        finally {
            this.mInSelectionChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vmSelectionChanged(ChangeEvent pEvent) {
        if (this.mInSelectionChange) {
            return;
        }
        this.mInSelectionChange = true;
        try {
            int index = this.mSelectionInList.selectionHolder().intValue();
            if (index == -1) {
                this.mListSelectionModel.clearSelection();
            } else {
                this.mListSelectionModel.setSelectionInterval(index, index);
            }
            ListDataEvent e = new ListDataEvent(this, 0, index, index);
            this.fireListChanged(e);
        }
        finally {
            this.mInSelectionChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleListSelection() {
        if (this.mInSelectionChange) {
            return;
        }
        if (this.mListSelectionModel.getValueIsAdjusting()) {
            return;
        }
        this.mInSelectionChange = true;
        try {
            this.mSelectionInList.selectionHolder().setValue(this.mListSelectionModel.getMinSelectionIndex());
        }
        finally {
            this.mInSelectionChange = false;
        }
    }

    @Override
    public void setSelectionInterval(int pIndex0, int pIndex1) {
        this.mListSelectionModel.setSelectionInterval(pIndex0, pIndex1);
        this.handleListSelection();
    }

    @Override
    public void addSelectionInterval(int pIndex0, int pIndex1) {
        this.mListSelectionModel.addSelectionInterval(pIndex0, pIndex1);
        this.handleListSelection();
    }

    @Override
    public void removeSelectionInterval(int pIndex0, int pIndex1) {
        this.mListSelectionModel.removeSelectionInterval(pIndex0, pIndex1);
        this.handleListSelection();
    }

    @Override
    public void insertIndexInterval(int pIndex, int pLength, boolean pBefore) {
        this.mListSelectionModel.insertIndexInterval(pIndex, pLength, pBefore);
        this.handleListSelection();
    }

    @Override
    public void removeIndexInterval(int pIndex0, int pIndex1) {
        this.mListSelectionModel.removeIndexInterval(pIndex0, pIndex1);
        this.handleListSelection();
    }

    @Override
    public void clearSelection() {
        this.mListSelectionModel.clearSelection();
        this.handleListSelection();
    }

    @Override
    public int getMinSelectionIndex() {
        return this.mListSelectionModel.getMinSelectionIndex();
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.mListSelectionModel.getMaxSelectionIndex();
    }

    @Override
    public boolean isSelectedIndex(int pIndex) {
        if (pIndex == -1) {
            return false;
        }
        return this.mListSelectionModel.isSelectedIndex(pIndex);
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.mListSelectionModel.getAnchorSelectionIndex();
    }

    @Override
    public void setAnchorSelectionIndex(int pIndex) {
        this.mListSelectionModel.setAnchorSelectionIndex(pIndex);
        this.handleListSelection();
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.mListSelectionModel.getLeadSelectionIndex();
    }

    @Override
    public void setLeadSelectionIndex(int pIndex) {
        this.mListSelectionModel.setLeadSelectionIndex(pIndex);
        this.handleListSelection();
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.mListSelectionModel.isSelectionEmpty();
    }

    @Override
    public void setValueIsAdjusting(boolean pValueIsAdjusting) {
        if (pValueIsAdjusting != this.mListSelectionModel.getValueIsAdjusting()) {
            this.mListSelectionModel.setValueIsAdjusting(pValueIsAdjusting);
            this.handleListSelection();
        }
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.mListSelectionModel.getValueIsAdjusting();
    }

    @Override
    public void setSelectionMode(int pSelectionMode) {
        if (pSelectionMode != 0) {
            throw new IllegalArgumentException("this selection model only supports single selection");
        }
        this.mListSelectionModel.setSelectionMode(pSelectionMode);
    }

    @Override
    public int getSelectionMode() {
        return this.mListSelectionModel.getSelectionMode();
    }

    @Override
    public void addListSelectionListener(ListSelectionListener pListener) {
        this.mListSelectionModel.addListSelectionListener(pListener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener pListener) {
        this.mListSelectionModel.removeListSelectionListener(pListener);
    }

    @Override
    public Object getSelectedItem() {
        int index = this.mSelectionInList.getIndex();
        return this.getElementAt(index);
    }

    @Override
    public void setSelectedItem(Object pItem) {
        int index = this.getIndexByObject(pItem);
        this.setSelectionInterval(index, index);
    }

    @Override
    public Object getElementAt(int pIndex) {
        if (pIndex == -1) {
            return null;
        }
        Object list = this.mSelectionInList.getValue();
        Object value = list.get(pIndex);
        if (this.mAccessValueModel != null) {
            value = this.mAccessValueModel.getValue(value);
        }
        return value;
    }

    @Override
    public int getSize() {
        if (this.mSelectionInList.getValue() != null) {
            return this.mSelectionInList.getValue().size();
        }
        return 0;
    }

    @Override
    public void addListDataListener(ListDataListener pListener) {
        this.mListenerList.add(ListDataListener.class, pListener);
    }

    @Override
    public void removeListDataListener(ListDataListener pListener) {
        this.mListenerList.remove(ListDataListener.class, pListener);
    }

    public void addElement(Object pObj) {
        this.mSelectionInList.addItem(pObj);
    }

    public void removeElement(Object pObj) {
        int index = this.getIndexByObject(pObj);
        if (index >= 0) {
            this.mSelectionInList.removeItem(index);
        }
    }

    public int getIndexByObject(Object pItem) {
        Object list = this.mSelectionInList.getValue();
        if (list == null) {
            return -1;
        }
        int index = -1;
        if (this.mAccessValueModel != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object item = this.mAccessValueModel.getValue(list.get(i));
                if (pItem != item && (pItem == null || !pItem.equals(item))) continue;
                index = i;
                break;
            }
        } else {
            index = list.indexOf(pItem);
        }
        return index;
    }
}

