/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.state;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.cuf.model.AbstractValueModel;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.state.MutableState;
import net.sf.cuf.state.State;

public class StateValue
extends AbstractValueModel<Boolean>
implements ValueModel<Boolean>,
ChangeListener {
    private State mState;
    private MutableState mMutableState;

    public StateValue(State pState) {
        if (pState == null) {
            throw new IllegalStateException("state must not be null");
        }
        this.mState = pState;
        if (this.mState instanceof MutableState) {
            this.mMutableState = (MutableState)this.mState;
        }
        this.setInSetValue(false, false);
        this.mState.addChangeListener(this);
    }

    @Override
    public boolean isEditable() {
        return this.mMutableState != null;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (!this.mState.isDisposed()) {
            this.mState.removeChangeListener(this);
        }
    }

    @Override
    public void stateChanged(ChangeEvent pEvent) {
        this.checkDisposed();
        if (this.isInSetValue()) {
            return;
        }
        this.fireStateChanged();
    }

    public State getState() {
        this.checkDisposed();
        return this.mState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Boolean pValue, boolean pIsSetForced) {
        this.checkDisposed();
        if (this.mMutableState == null) {
            throw new UnsupportedOperationException("our state is not mutable");
        }
        if (pValue == null) {
            pValue = Boolean.FALSE;
        }
        try {
            boolean enabled = pValue;
            this.setInSetValue(true, pIsSetForced);
            this.mMutableState.setEnabled(enabled, this);
            this.fireStateChanged();
        }
        finally {
            this.setInSetValue(false, false);
        }
    }

    @Override
    public Boolean getValue() {
        this.checkDisposed();
        return this.mState.isEnabled();
    }
}

