/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.converter;

import java.text.NumberFormat;
import java.text.ParseException;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.model.converter.AbstractNumberStringConverter;

public class DoubleStringConverter
extends AbstractNumberStringConverter<Double> {
    private NumberFormat mFormat;

    public DoubleStringConverter(ValueModel<Double> pSubject) {
        this(pSubject, null, true);
    }

    public DoubleStringConverter(ValueModel<Double> pSubject, boolean pNullIsValid) {
        this(pSubject, null, pNullIsValid);
    }

    public DoubleStringConverter(ValueModel<Double> pSubject, NumberFormat pFormat) {
        this(pSubject, pFormat, true);
    }

    public DoubleStringConverter(ValueModel<Double> pSubject, NumberFormat pFormat, boolean pNullIsValid) {
        super(pSubject, pNullIsValid);
        this.mFormat = pFormat;
    }

    @Override
    protected String convertToString(Number pSubjectValue) {
        if (this.mFormat != null) {
            return this.mFormat.format(pSubjectValue.doubleValue());
        }
        return pSubjectValue.toString();
    }

    @Override
    protected Double convertToNumber(String pOwnValue) throws NumberFormatException {
        if (this.mFormat != null) {
            try {
                return this.mFormat.parse(pOwnValue).doubleValue();
            }
            catch (ParseException e) {
                NumberFormatException ex = new NumberFormatException("Could not parse string: " + e);
                ex.initCause(e);
                throw ex;
            }
        }
        return new Double(pOwnValue);
    }
}

