/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model;

import java.util.Comparator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.cuf.model.AbstractValueModel;
import net.sf.cuf.model.ExternalUpdate;
import net.sf.cuf.model.IndexProvider;
import net.sf.cuf.model.IndexValidHolder;
import net.sf.cuf.model.ValueHolder;
import net.sf.cuf.model.ValueModel;

public class SelectionInList<T>
extends AbstractValueModel<List<T>>
implements ValueModel<List<T>>,
ChangeListener,
ExternalUpdate,
IndexProvider {
    private ValueModel<List<T>> mListHolder;
    private IndexProvider mIndexProvider;
    private ExternalUpdate mExternalUpdate;
    private List<T> mList;
    private ValueModel<Integer> mSelectionIndexHolder;
    private IndexValidHolder mIndexInList;
    private boolean mKeepSelection;
    private Comparator<T> mSelectionComparator;
    public static final Integer NO_SELECTION = -1;

    public SelectionInList(ValueModel<List<T>> pListHolder) {
        this(pListHolder, -1);
    }

    public SelectionInList(ValueModel<List<T>> pListHolder, int pIndex) {
        if (pListHolder == null) {
            throw new IllegalArgumentException("list holder must not be null");
        }
        this.init(pListHolder.getValue(), pListHolder, pIndex);
    }

    public SelectionInList(List<T> pList) {
        this(pList, -1);
    }

    public SelectionInList(List<T> pList, int pIndex) {
        this.init(pList, null, pIndex);
    }

    private void init(List<T> pList, ValueModel<List<T>> pListHolder, int pIndex) {
        this.mList = pList;
        this.mListHolder = pListHolder;
        this.setInSetValue(false, false);
        if (this.mListHolder instanceof IndexProvider) {
            this.mIndexProvider = (IndexProvider)((Object)this.mListHolder);
            pIndex = this.mIndexProvider.getIndex();
        } else {
            this.mIndexProvider = null;
        }
        if (this.mListHolder instanceof ExternalUpdate) {
            this.mExternalUpdate = (ExternalUpdate)((Object)this.mListHolder);
        }
        this.mIndexInList = new IndexValidHolder(pIndex);
        this.mSelectionIndexHolder = new SelectionIndexHolder(pIndex);
        if (this.mListHolder != null) {
            this.mListHolder.addChangeListener(this);
        }
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.mListHolder != null && !this.mListHolder.isDisposed()) {
            this.mListHolder.removeChangeListener(this);
        }
        this.mSelectionIndexHolder.dispose();
        this.mIndexInList.dispose();
    }

    private static void checkIndex(int pIndex, List<?> pList) {
        int maxSize = -1;
        if (pList != null) {
            maxSize = pList.size() - 1;
        }
        if (pIndex < -1 || pIndex > maxSize) {
            throw new IllegalArgumentException("index out of range, got " + pIndex + ", but list size is " + (maxSize + 1));
        }
    }

    public void setKeepSelection(boolean pKeepSelection) {
        this.mKeepSelection = pKeepSelection;
    }

    public boolean isKeepSelection() {
        return this.mKeepSelection;
    }

    public Comparator<?> getSelectionComparator() {
        return this.mSelectionComparator;
    }

    public void setSelectionComparator(Comparator<T> pSelectionComparator) {
        this.mSelectionComparator = pSelectionComparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(List<T> pValue, boolean pIsSetForced) {
        this.checkDisposed();
        if (this.isInSetValue()) {
            return;
        }
        if (pValue != null && !(pValue instanceof List)) {
            throw new IllegalArgumentException("value must be a List or null, not a " + pValue.getClass().getName());
        }
        int oldSelectionIndex = this.mSelectionIndexHolder.intValue();
        T oldSelectedObject = null;
        if (oldSelectionIndex >= 0 && this.mList != null && oldSelectionIndex < this.mList.size()) {
            oldSelectedObject = this.mList.get(oldSelectionIndex);
        }
        if (this.mListHolder == null && !pIsSetForced && (this.mList == null ? pValue == null : this.mList.equals(pValue))) {
            return;
        }
        this.setInSetValue(true, pIsSetForced);
        try {
            Integer newIndex = NO_SELECTION;
            boolean forced = false;
            if (this.mListHolder != null) {
                this.mListHolder.setValue(pValue);
            }
            this.mList = pValue;
            if (this.mKeepSelection && oldSelectionIndex >= 0) {
                newIndex = this.findIndexInList(this.mList, oldSelectedObject);
                forced = true;
            }
            this.mSelectionIndexHolder.setValue(newIndex, forced);
            this.fireStateChanged();
        }
        finally {
            this.setInSetValue(false, false);
        }
    }

    private int findIndexInList(List<T> pList, T pObject) {
        if (pList == null) {
            return -1;
        }
        if (this.mSelectionComparator == null) {
            return pList.indexOf(pObject);
        }
        for (int i = 0; i < pList.size(); ++i) {
            T objInList = pList.get(i);
            if (!(pObject == null ? objInList == null : objInList != null && this.mSelectionComparator.compare(pObject, objInList) == 0)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<T> getValue() {
        try {
            this.checkDisposed();
        }
        catch (IllegalStateException e) {
            return null;
        }
        return this.mList;
    }

    @Override
    public int getIndex() {
        this.checkDisposed();
        return this.mSelectionIndexHolder.intValue();
    }

    public void addItem(T pItem) {
        this.checkDisposed();
        int index = this.mSelectionIndexHolder.intValue();
        if (index == NO_SELECTION) {
            this.addItem(this.mList.size(), pItem);
        } else {
            this.addItem(index, pItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(int pIndex, T pItem) {
        this.checkDisposed();
        if (this.isInSetValue()) {
            throw new IllegalStateException("addItem called during setValue, index= " + pIndex + ", new item= " + pItem);
        }
        this.setInSetValue(true, false);
        try {
            this.mList.add(pIndex, pItem);
            if (this.mExternalUpdate != null) {
                this.mExternalUpdate.signalExternalUpdate();
            }
            this.mSelectionIndexHolder.setValueForced(pIndex);
            this.fireStateChanged();
        }
        finally {
            this.setInSetValue(false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeItem(int pIndex) {
        this.checkDisposed();
        if (this.isInSetValue()) {
            throw new IllegalStateException("removeItem called during setValue, index= " + pIndex);
        }
        if (pIndex == NO_SELECTION) {
            return null;
        }
        Object back = null;
        this.setInSetValue(true, false);
        try {
            back = this.mList.remove(pIndex);
            if (this.mExternalUpdate != null) {
                this.mExternalUpdate.signalExternalUpdate();
            }
            int index = pIndex;
            if (pIndex == this.mList.size()) {
                index = this.mList.size() - 1;
            }
            this.mSelectionIndexHolder.setValue(new Integer(index));
            this.fireStateChanged();
        }
        finally {
            this.setInSetValue(false, false);
        }
        return back;
    }

    public Object removeItem() {
        return this.removeItem(this.selectionHolder().intValue());
    }

    @Override
    public void stateChanged(ChangeEvent pEvent) {
        this.checkDisposed();
        if (this.isInSetValue()) {
            return;
        }
        int oldSelectionIndex = this.mSelectionIndexHolder.intValue();
        T oldSelectedObject = null;
        if (oldSelectionIndex >= 0 && this.mList != null && oldSelectionIndex < this.mList.size()) {
            oldSelectedObject = this.mList.get(oldSelectionIndex);
        }
        List<T> value = this.mListHolder.getValue();
        int index = -1;
        if (this.mIndexProvider != null) {
            index = this.mIndexProvider.getIndex();
        }
        SelectionInList.checkIndex(index, value);
        this.mList = value;
        if (this.mKeepSelection && oldSelectionIndex >= 0) {
            this.mSelectionIndexHolder.setValueForced(this.findIndexInList(this.mList, oldSelectedObject));
        } else {
            this.mSelectionIndexHolder.setValue(new Integer(index));
        }
        this.fireStateChanged();
    }

    public ValueModel<Boolean> isIndexInList() {
        return this.mIndexInList;
    }

    public ValueModel<Integer> selectionHolder() {
        this.checkDisposed();
        return this.mSelectionIndexHolder;
    }

    public ValueModel<List<T>> listHolder() {
        return this.mListHolder;
    }

    private class SelectionIndexHolder
    extends ValueHolder<Integer> {
        SelectionIndexHolder(int pIndex) {
            this.setValue(new Integer(pIndex));
        }

        @Override
        public void setValue(Integer pValue, boolean pIsSetForced) {
            this.checkDisposed();
            if (pValue == null) {
                throw new IllegalArgumentException("selection must not be null");
            }
            int index = pValue;
            SelectionInList.checkIndex(index, SelectionInList.this.mList);
            super.setValue(pValue, pIsSetForced);
            SelectionInList.this.mIndexInList.setIndex(index);
        }
    }
}

