/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import net.sf.cuf.model.AspectAccessAdapter;

public class MethodAccessAdapter
implements AspectAccessAdapter {
    private Method[] mGetMethods;
    private Method mSetMethod;

    public MethodAccessAdapter(Class<?> pSourceClass, String pAspectName) {
        if (pSourceClass == null) {
            throw new IllegalArgumentException("SourceClass must not be null");
        }
        if (pAspectName == null) {
            throw new IllegalArgumentException("AspectName must not be null");
        }
        if (pAspectName.length() == 0) {
            throw new IllegalArgumentException("AspectName must not be empty");
        }
        StringTokenizer st = new StringTokenizer(pAspectName, ".");
        Class<?> sourceClass = pSourceClass;
        Class<?> lastSourceClass = null;
        String attribute = null;
        this.mGetMethods = new Method[st.countTokens()];
        try {
            for (int i = 0; i < this.mGetMethods.length; ++i) {
                Method getter;
                attribute = st.nextToken();
                String getterName = "get" + attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
                try {
                    getter = sourceClass.getMethod(getterName, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("Class " + sourceClass + " does not have a method " + getterName + "()");
                }
                this.mGetMethods[i] = getter;
                lastSourceClass = sourceClass;
                sourceClass = getter.getReturnType();
            }
            String setterName = "set" + attribute.substring(0, 1).toUpperCase() + attribute.substring(1);
            try {
                this.mSetMethod = lastSourceClass.getMethod(setterName, sourceClass);
            }
            catch (NoSuchMethodException e) {
                this.mSetMethod = null;
            }
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException();
            iae.initCause(e);
            throw iae;
        }
    }

    @Override
    public boolean isEditable() {
        return this.mSetMethod != null;
    }

    @Override
    public Object getValue(Object pSource) {
        if (pSource == null) {
            return null;
        }
        Object aspect = pSource;
        try {
            for (Method getMethod : this.mGetMethods) {
                try {
                    aspect = getMethod.invoke(aspect, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    IllegalArgumentException iae = new IllegalArgumentException("While invoking method " + getMethod + " on object of class " + aspect.getClass() + ": " + e.getMessage());
                    iae.initCause(e);
                    throw iae;
                }
            }
        }
        catch (IllegalAccessException e) {
            IllegalArgumentException iae = new IllegalArgumentException(e.getMessage());
            iae.initCause(e);
            throw iae;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new IllegalArgumentException(cause != null ? cause.getMessage() : e.getMessage());
        }
        return aspect;
    }

    @Override
    public void setValue(Object pSource, Object pValue) {
        try {
            Object aspect = pSource;
            for (int i = 0; i < this.mGetMethods.length - 1; ++i) {
                Method getMethod = this.mGetMethods[i];
                aspect = getMethod.invoke(aspect, new Object[0]);
            }
            this.mSetMethod.invoke(aspect, pValue);
        }
        catch (IllegalArgumentException e) {
            IllegalArgumentException ex = new IllegalArgumentException("Error while calling " + this.mSetMethod + " (setting value " + pValue + "): " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IllegalAccessException e) {
            IllegalArgumentException ex = new IllegalArgumentException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getTargetException();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            IllegalArgumentException ex = new IllegalArgumentException(cause != null ? cause.getMessage() : e.getMessage());
            if (cause != null) {
                ex.initCause(cause);
            }
            throw ex;
        }
    }
}

