/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.csvview.util;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import net.sf.cuf.model.ValueModel;

public class TableRowCopyAction
extends AbstractAction {
    private ValueModel<?> mCopyRow;

    public TableRowCopyAction(ValueModel<?> pCopyRow) {
        if (pCopyRow == null) {
            throw new IllegalArgumentException("copy row model must not be null");
        }
        this.mCopyRow = pCopyRow;
    }

    @Override
    public void actionPerformed(ActionEvent pEvent) {
        if (!(pEvent.getSource() instanceof JTable)) {
            return;
        }
        JTable table = (JTable)pEvent.getSource();
        int selectedRow = table.getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        boolean copyRow = this.mCopyRow.booleanValue();
        StringBuilder sb = new StringBuilder();
        if (copyRow) {
            int[] selectedRows = table.getSelectedRows();
            int columns = table.getColumnCount();
            int[] arr$ = selectedRows;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int selectedRow1;
                selectedRow = selectedRow1 = arr$[i$];
                for (int column = 0; column < columns; ++column) {
                    sb.append(table.getModel().getValueAt(selectedRow, column));
                    if (column >= columns - 1) continue;
                    sb.append('\t');
                }
                sb.append('\n');
            }
        } else {
            int selectedColumn = table.getSelectedColumn();
            if (selectedColumn < 0) {
                return;
            }
            int realColumn = table.convertColumnIndexToModel(selectedColumn);
            sb.append(table.getModel().getValueAt(selectedRow, realColumn));
        }
        StringSelection selection = new StringSelection(sb.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }
}

