/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TableSortInfo {
    private List<Entry> mSortingCriteria;

    public TableSortInfo() {
        this.mSortingCriteria = new ArrayList<Entry>();
    }

    private TableSortInfo(TableSortInfo pOriginal) {
        this.mSortingCriteria = Collections.unmodifiableList(pOriginal.mSortingCriteria);
    }

    public TableSortInfo cloneImmutable() {
        return new TableSortInfo(this);
    }

    public void clear() {
        this.mSortingCriteria.clear();
    }

    public int size() {
        return this.mSortingCriteria.size();
    }

    public boolean isSorted(int pColumnIndex) {
        return this.find(pColumnIndex) >= 0;
    }

    public int find(int pColumnIndex) {
        int entryIndex = 0;
        for (Entry aSortingCriteria : this.mSortingCriteria) {
            Entry entry = aSortingCriteria;
            if (entry.getPColumn() == pColumnIndex) {
                return entryIndex;
            }
            ++entryIndex;
        }
        return -1;
    }

    public int getColumn(int pEntryIndex) {
        return this.mSortingCriteria.get(pEntryIndex).getPColumn();
    }

    public boolean isAscending(int pEntryIndex) {
        return this.mSortingCriteria.get(pEntryIndex).isAscending();
    }

    public void sortByColumn(int pColumn, boolean pAscending) {
        Entry entry = new Entry(pColumn, pAscending);
        this.mSortingCriteria.remove(entry);
        this.mSortingCriteria.add(entry);
    }

    public static class Entry {
        private int mColumn;
        private boolean mAscending;

        public Entry(int pColumn, boolean pAscending) {
            this.mColumn = pColumn;
            this.mAscending = pAscending;
        }

        public int getPColumn() {
            return this.mColumn;
        }

        public boolean isAscending() {
            return this.mAscending;
        }

        public boolean equals(Object pOther) {
            if (pOther instanceof Entry) {
                Entry other = (Entry)pOther;
                return this.mColumn == other.mColumn;
            }
            return false;
        }

        public int hashCode() {
            return this.mColumn;
        }
    }
}

