/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import net.sf.cuf.ui.SwingDecorator;
import net.sf.cuf.ui.table.ContextMenuAction;
import net.sf.cuf.ui.table.ContextMenuActionColumnToEdge;
import net.sf.cuf.ui.table.ContextMenuActionHideColumn;
import net.sf.cuf.ui.table.ContextMenuActionOptimalColumnWidth;
import net.sf.cuf.ui.table.ContextMenuActionResetColumns;
import net.sf.cuf.ui.table.ContextMenuActionShowAll;
import net.sf.cuf.ui.table.ContextMenuActionSortColumn;
import net.sf.cuf.ui.table.ContextMenuActionSortDialog;
import net.sf.cuf.ui.table.ContextMenuActionVisibilityDialog;
import net.sf.cuf.ui.table.ContextMenuAdapter;
import net.sf.cuf.ui.table.GuiUtilities;
import net.sf.cuf.ui.table.SortingTable;

public class TableContextMenu
extends MouseAdapter
implements AncestorListener {
    public static final int CONTEXT_MENU_IN_TABLE = 1;
    public static final int CONTEXT_MENU_IN_HEADER = 2;
    public static final int CONTEXT_MENU_IN_VIEWPORT = 4;
    public static final int CONTEXT_MENU_IN_TABLE_HEADER = 2;
    public static final int CONTEXT_MENU_IN_WHOLE_TABLE = 3;
    public static final int CONTEXT_MENU_IN_TABLE_AND_PARENT = 7;
    public static final ContextMenuAction SEPARATOR = null;
    private static final String KENNUNG = "TABLESORT_CONTEXTMENU";
    private JTable mTable;
    private int mMode = 0;
    private ContextMenuAction[] mActions;
    private Container mTableParent = null;
    private JPopupMenu mPopup = null;
    private int mViewIndexOfColumnUnderMouse;
    private int mModelIndexOfColumnUnderMouse;
    private int mIndexOfRowUnderMouse;

    private static ContextMenuAction[] createDefaultActions(JTable pTable) {
        ContextMenuAction[] actions;
        if (pTable instanceof SortingTable) {
            ContextMenuAction[] a = new ContextMenuAction[]{new ContextMenuActionSortColumn(true), new ContextMenuActionSortColumn(false), new ContextMenuActionHideColumn(), new ContextMenuActionColumnToEdge(1), new ContextMenuActionColumnToEdge(2), new ContextMenuActionOptimalColumnWidth(), new ContextMenuActionShowAll(), new ContextMenuActionResetColumns(), SEPARATOR, new ContextMenuActionSortDialog(), new ContextMenuActionVisibilityDialog()};
            actions = a;
        } else {
            ContextMenuAction[] a;
            actions = a = new ContextMenuAction[]{new ContextMenuActionColumnToEdge(1), new ContextMenuActionColumnToEdge(2), new ContextMenuActionOptimalColumnWidth(), new ContextMenuActionResetColumns()};
        }
        return actions;
    }

    public TableContextMenu(JTable pTable) {
        this(pTable, 7);
    }

    public TableContextMenu(JTable pTable, int pMode) {
        this(pTable, pMode, TableContextMenu.createDefaultActions(pTable));
    }

    public TableContextMenu(JTable pTable, int pMode, ContextMenuAction[] pActions) {
        if (pTable == null) {
            throw new IllegalArgumentException("table must not be null");
        }
        if (pActions == null || pActions.length == 0) {
            throw new IllegalArgumentException("actions must not be null or empty");
        }
        this.mTable = pTable;
        this.mActions = pActions;
        Adapter adapter = new Adapter();
        for (ContextMenuAction action : pActions) {
            if (action == null) continue;
            action.initialize(adapter);
        }
        pTable.addAncestorListener(this);
        this.setMode(pMode);
    }

    public void dispose() {
        this.setMode(0);
        this.mTable.removeAncestorListener(this);
        this.mTable = null;
    }

    public int getMode() {
        return this.mMode;
    }

    public void setMode(int pMode) {
        if ((this.mMode & 2) != 0) {
            this.mTable.getTableHeader().removeMouseListener(this);
        }
        if ((this.mMode & 1) != 0) {
            this.mTable.removeMouseListener(this);
        }
        if (this.mTableParent != null) {
            this.mTableParent.removeMouseListener(this);
            this.mTableParent = null;
        }
        this.mMode = pMode;
        if ((pMode & 2) != 0) {
            this.mTable.getTableHeader().addMouseListener(this);
        }
        if ((pMode & 1) != 0) {
            this.mTable.addMouseListener(this);
        }
        this.checkTableParent();
    }

    private void checkTableParent() {
        Container currentParent;
        if ((this.mMode & 4) != 0 && (currentParent = this.mTable.getParent()) != this.mTableParent) {
            if (this.mTableParent != null) {
                this.mTableParent.removeMouseListener(this);
                this.mTableParent = null;
            }
            if (currentParent instanceof JViewport) {
                this.mTableParent = currentParent;
                this.mTableParent.addMouseListener(this);
            }
        }
    }

    private void processMouseClickInTable(MouseEvent pEvent) {
        if (!pEvent.isConsumed() && pEvent.isPopupTrigger()) {
            SwingUtilities.invokeLater(new ShowPopup(pEvent));
            pEvent.consume();
        }
    }

    private JPopupMenu getPopup() {
        if (this.mPopup == null) {
            this.mPopup = new JPopupMenu(SwingDecorator.getTitle(KENNUNG));
            for (ContextMenuAction action : this.mActions) {
                if (action == null) {
                    this.mPopup.addSeparator();
                    continue;
                }
                JMenuItem mi = new JMenuItem();
                SwingDecorator.initialize(mi, action.getKennung());
                mi.addActionListener(action);
                this.mPopup.add(mi);
            }
        }
        return this.mPopup;
    }

    @Override
    public void mousePressed(MouseEvent pEvent) {
        this.processMouseClickInTable(pEvent);
    }

    @Override
    public void mouseReleased(MouseEvent pEvent) {
        this.processMouseClickInTable(pEvent);
    }

    @Override
    public void ancestorAdded(AncestorEvent pEvent) {
        this.checkTableParent();
    }

    @Override
    public void ancestorRemoved(AncestorEvent pEvent) {
        this.checkTableParent();
    }

    @Override
    public void ancestorMoved(AncestorEvent pEvent) {
    }

    private class Adapter
    implements ContextMenuAdapter {
        private Adapter() {
        }

        @Override
        public String getContextMenuKennung() {
            return TableContextMenu.KENNUNG;
        }

        @Override
        public JTable getTable() {
            return TableContextMenu.this.mTable;
        }

        @Override
        public int getViewColumnIndex() {
            return TableContextMenu.this.mViewIndexOfColumnUnderMouse;
        }

        @Override
        public int getModelColumnIndex() {
            return TableContextMenu.this.mModelIndexOfColumnUnderMouse;
        }

        @Override
        public int getRowIndex() {
            return TableContextMenu.this.mIndexOfRowUnderMouse;
        }

        @Override
        public Frame getFrameForTable() throws IllegalStateException {
            Window frame = SwingUtilities.windowForComponent(this.getTable());
            if (frame == null || !(frame instanceof Frame)) {
                throw new IllegalStateException("the table this context menu works on must reside in a java.awt.Frame");
            }
            return (Frame)frame;
        }
    }

    private class ShowPopup
    implements Runnable {
        private Component mComponent;
        private Point mPosition;

        public ShowPopup(MouseEvent pEvent) {
            this.mComponent = pEvent.getComponent();
            this.mPosition = (Point)pEvent.getPoint().clone();
        }

        @Override
        public void run() {
            TableContextMenu.this.mViewIndexOfColumnUnderMouse = -1;
            if (this.mComponent != TableContextMenu.this.mTableParent) {
                TableContextMenu.this.mViewIndexOfColumnUnderMouse = TableContextMenu.this.mTable.columnAtPoint(this.mPosition);
            }
            TableContextMenu.this.mModelIndexOfColumnUnderMouse = TableContextMenu.this.mTable.convertColumnIndexToModel(TableContextMenu.this.mViewIndexOfColumnUnderMouse);
            TableContextMenu.this.mIndexOfRowUnderMouse = -1;
            if (this.mComponent == TableContextMenu.this.mTable) {
                TableContextMenu.this.mIndexOfRowUnderMouse = TableContextMenu.this.mTable.rowAtPoint(this.mPosition);
            }
            for (int i = 0; i < TableContextMenu.this.mActions.length; ++i) {
                if (TableContextMenu.this.mActions[i] == SEPARATOR) continue;
                TableContextMenu.this.getPopup().getComponent(i).setEnabled(TableContextMenu.this.mActions[i].isEnabled());
            }
            GuiUtilities.getDefault().showPopupAdjusted(TableContextMenu.this.getPopup(), this.mComponent, this.mPosition);
        }
    }
}

