/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui.builder;

import java.awt.Color;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.model.state.CollectionFilledState;
import net.sf.cuf.model.state.EqualsState;
import net.sf.cuf.model.state.NullState;
import net.sf.cuf.model.state.RegExpState;
import net.sf.cuf.model.state.ValueState;
import net.sf.cuf.state.MutableState;
import net.sf.cuf.state.SimpleState;
import net.sf.cuf.state.SimpleStateExpression;
import net.sf.cuf.state.State;
import net.sf.cuf.state.StateAdapter;
import net.sf.cuf.state.ui.SwingBackgroundAdapter;
import net.sf.cuf.state.ui.SwingBorderAdapter;
import net.sf.cuf.state.ui.SwingDocumentState;
import net.sf.cuf.state.ui.SwingEditableAdapter;
import net.sf.cuf.state.ui.SwingEnabledAdapter;
import net.sf.cuf.state.ui.SwingEnabledState;
import net.sf.cuf.state.ui.SwingJTableEnabledAdapter;
import net.sf.cuf.state.ui.SwingListModelFillState;
import net.sf.cuf.state.ui.SwingListSelectionState;
import net.sf.cuf.state.ui.SwingSelectedAdapter;
import net.sf.cuf.state.ui.SwingSelectedState;
import net.sf.cuf.state.ui.SwingTableModelFillState;
import net.sf.cuf.state.ui.SwingTreeModelFillState;
import net.sf.cuf.state.ui.SwingTreeSelectionState;
import net.sf.cuf.state.ui.SwingVisibleAdapter;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.ui.builder.VisualBuilderDelegate;
import org.jdom2.Element;

class StateHandlingBuilderDelegate
implements SwingXMLBuilder.BuilderDelegate {
    StateHandlingBuilderDelegate() {
    }

    @Override
    public void build(SwingXMLBuilder pBuilder, Element pStateHandlingElement) {
        List<Element> statehandlings = pStateHandlingElement.getChildren();
        for (Element element : statehandlings) {
            String objectType = element.getName();
            Object object = null;
            String id = element.getAttributeValue("id");
            if (objectType.equals("state")) {
                object = this.createState(element, id, pBuilder);
            } else if (objectType.equals("expression")) {
                object = this.createStateExpression(element, id, pBuilder);
            } else if (objectType.equals("stateAdapter")) {
                object = this.createStateAdapter(element, id, pBuilder);
            } else if (objectType.equals("setstate")) {
                this.setState(element, id, pBuilder);
            } else {
                throw SwingXMLBuilder.createException("unknown state handling " + objectType, element);
            }
            if (id == null || object == null) continue;
            if (pBuilder.getNameToNonVisual().containsKey(id)) {
                throw SwingXMLBuilder.createException("nonvisual with id " + id + " already defined", element);
            }
            pBuilder.getNameToNonVisual().put(id, object);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object createState(Element pElement, String pId, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        void var6_33;
        if (pId == null) {
            throw SwingXMLBuilder.createException("id of " + pElement.getName() + " must not be null", pElement);
        }
        String type = pElement.getAttributeValue("type");
        String refId = pElement.getAttributeValue("ref");
        Object var6_6 = null;
        if ("simple".equals(type)) {
            SimpleState simpleState = new SimpleState();
        } else if ("custom".equals(type)) {
            void var6_9;
            Class<?> customClass = SwingXMLBuilder.getClass(pElement);
            if (refId == null) {
                try {
                    State state = (State)customClass.newInstance();
                }
                catch (Exception e) {
                    throw SwingXMLBuilder.createException("could not create state for class " + customClass, e, pElement);
                }
            }
            Object ref = pBuilder.getNonVisualObject(refId);
            if (ref == null) {
                ref = pBuilder.getComponentByAnyName(refId);
            }
            if (ref == null) {
                throw SwingXMLBuilder.createException(refId + " doesn't map to an object", pElement);
            }
            try {
                Constructor<?>[] constructors;
                for (Constructor<?> constructor : constructors = customClass.getConstructors()) {
                    Class<?>[] parameters = constructor.getParameterTypes();
                    if (parameters.length != 1 || !parameters[0].isAssignableFrom(ref.getClass())) continue;
                    Object[] args = new Object[]{ref};
                    State state = (State)constructor.newInstance(args);
                }
            }
            catch (Exception e) {
                throw SwingXMLBuilder.createException("could not create state for class " + customClass + " with argument " + ref, e, pElement);
            }
            if (var6_9 == null) {
                throw SwingXMLBuilder.createException("could not create state for class " + customClass + " with argument " + ref, pElement);
            }
        } else if ("value".equals(type)) {
            Object ref = pBuilder.getNonVisualObject(refId);
            if (!(ref instanceof ValueModel)) {
                throw SwingXMLBuilder.createException("selected state ref (" + refId + ")is no ValueModel", pElement);
            }
            ValueState valueState = new ValueState((ValueModel)ref);
        } else if ("enabled".equals(type)) {
            void var6_15;
            Object ref = pBuilder.getNonVisualObject(refId);
            if (ref instanceof Action) {
                SwingEnabledState swingEnabledState = new SwingEnabledState((Action)ref);
            } else {
                ref = pBuilder.getComponentByAnyName(refId);
                if (ref instanceof JComponent) {
                    SwingEnabledState swingEnabledState = new SwingEnabledState((JComponent)ref);
                }
            }
            if (var6_15 == null) {
                throw SwingXMLBuilder.createException("selected state ref (" + refId + ") is not known", pElement);
            }
        } else if ("selected".equals(type)) {
            JComponent ref = pBuilder.getComponentByAnyName(refId);
            if (!(ref instanceof AbstractButton)) {
                throw SwingXMLBuilder.createException("selected state ref (" + refId + ") is no AbstractButton", pElement);
            }
            SwingSelectedState swingSelectedState = new SwingSelectedState((AbstractButton)ref);
        } else if ("document".equals(type)) {
            JComponent ref = pBuilder.getComponentByAnyName(refId);
            if (!(ref instanceof JTextComponent)) {
                throw SwingXMLBuilder.createException("selected state ref (" + refId + ") is no JTextComponent", pElement);
            }
            SwingDocumentState swingDocumentState = new SwingDocumentState((JTextComponent)ref);
        } else if ("listSelection".equals(type)) {
            JComponent ref = pBuilder.getComponentByAnyName(refId);
            if (ref == null) {
                throw SwingXMLBuilder.createException("selected state ref (" + refId + ") is not known", pElement);
            }
            if (ref instanceof JList) {
                SwingListSelectionState swingListSelectionState = new SwingListSelectionState((JList)ref);
            } else if (ref instanceof JTable) {
                SwingListSelectionState swingListSelectionState = new SwingListSelectionState((JTable)ref);
            } else {
                if (!(ref instanceof JComboBox)) throw SwingXMLBuilder.createException("selected state ref (" + refId + ") is not a JList/JTable/JComboBox", pElement);
                SwingListSelectionState swingListSelectionState = new SwingListSelectionState((JComboBox)ref);
            }
        } else if ("listFill".equals(type)) {
            JComponent ref = pBuilder.getComponentByAnyName(refId);
            if (!(ref instanceof JList)) throw SwingXMLBuilder.createException("selected state ref (" + refId + ") is not a JList", pElement);
            SwingListModelFillState swingListModelFillState = new SwingListModelFillState((JList)ref);
        } else if ("tableFill".equals(type)) {
            JComponent ref = pBuilder.getComponentByAnyName(refId);
            if (!(ref instanceof JTable)) throw SwingXMLBuilder.createException("selected state ref (" + refId + ") is not a JTable", pElement);
            SwingTableModelFillState swingTableModelFillState = new SwingTableModelFillState((JTable)ref);
        } else if ("treeFill".equals(type)) {
            JComponent ref = pBuilder.getComponentByAnyName(refId);
            if (!(ref instanceof JTree)) throw SwingXMLBuilder.createException("selected state ref (" + refId + ") is not a JTree", pElement);
            SwingTreeModelFillState swingTreeModelFillState = new SwingTreeModelFillState((JTree)ref);
        } else if ("collectionFill".equals(type)) {
            Object ref = pBuilder.getNonVisualObject(refId);
            if (!(ref instanceof ValueModel)) throw SwingXMLBuilder.createException("selected state ref (" + refId + ") is not a ValueModel", pElement);
            CollectionFilledState collectionFilledState = new CollectionFilledState((ValueModel)ref);
        } else if ("treeSelection".equals(type)) {
            JComponent ref = pBuilder.getComponentByAnyName(refId);
            if (!(ref instanceof JTree)) throw SwingXMLBuilder.createException("selected state ref (" + refId + ") is not a JTree", pElement);
            SwingTreeSelectionState swingTreeSelectionState = new SwingTreeSelectionState((JTree)ref);
        } else if ("nullState".equals(type)) {
            Object ref = pBuilder.getNonVisualObject(refId);
            if (!(ref instanceof ValueModel)) throw SwingXMLBuilder.createException("selected state ref (" + refId + ") is not a ValueModel", pElement);
            NullState nullState = new NullState((ValueModel)ref);
        } else if ("equals".equals(type)) {
            Object ref = pBuilder.getNonVisualObject(refId);
            String refId2 = pElement.getAttributeValue("ref2");
            String value = pElement.getAttributeValue("value");
            Object ref2 = pBuilder.getNonVisualObject(refId2);
            if (!(ref instanceof ValueModel)) {
                throw SwingXMLBuilder.createException("selected state ref (" + refId + ") is not a ValueModel", pElement);
            }
            if (refId2 != null) {
                if (ref2 instanceof ValueModel) {
                    EqualsState equalsState = new EqualsState((ValueModel)ref, (ValueModel)ref2);
                } else {
                    EqualsState equalsState = new EqualsState((ValueModel)ref, ref2);
                }
            } else {
                EqualsState equalsState = new EqualsState((ValueModel)ref, value);
            }
        } else if ("regexp".equals(type)) {
            Object ref = pBuilder.getNonVisualObject(refId);
            String value = pElement.getAttributeValue("value");
            if (!(ref instanceof ValueModel)) {
                throw SwingXMLBuilder.createException("selected state ref (" + refId + ") is not a ValueModel", pElement);
            }
            if (value == null) {
                throw SwingXMLBuilder.createException("selected state value must not be null", pElement);
            }
            RegExpState regExpState = new RegExpState((ValueModel)ref, value);
        }
        if (var6_33 == null) {
            throw SwingXMLBuilder.createException("unknown state type " + type, pElement);
        }
        var6_33.setName(pId);
        return var6_33;
    }

    private Object createStateExpression(Element pElement, String pId, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        if (pId == null) {
            throw SwingXMLBuilder.createException("id of " + pElement.getName() + " must not be null", pElement);
        }
        State startState = this.getState(pElement, pBuilder, "ref");
        boolean invert = this.getInvertFlag(pElement);
        SimpleStateExpression stateExpression = new SimpleStateExpression(startState, invert);
        List<Element> conditions = pElement.getChildren();
        for (Element element : conditions) {
            String elementName = element.getName();
            State state = this.getState(element, pBuilder, "ref");
            invert = this.getInvertFlag(element);
            if ("and".equals(elementName)) {
                stateExpression.and(state, invert);
                continue;
            }
            if ("andNot".equals(elementName)) {
                stateExpression.andNot(state);
                continue;
            }
            if ("or".equals(elementName)) {
                stateExpression.or(state, invert);
                continue;
            }
            if ("orNot".equals(elementName)) {
                stateExpression.orNot(state);
                continue;
            }
            if ("xor".equals(elementName)) {
                stateExpression.xor(state, invert);
                continue;
            }
            if (!"xorNot".equals(elementName)) continue;
            stateExpression.xorNot(state);
        }
        return stateExpression;
    }

    private Object createStateAdapter(Element pElement, String pId, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        String type = pElement.getAttributeValue("type");
        State state = this.getState(pElement, pBuilder, "ref");
        StateAdapter stateAdapter = null;
        if ("custom".equals(type)) {
            Class<?> customClass = SwingXMLBuilder.getClass(pElement);
            try {
                Class[] params = new Class[]{State.class};
                Constructor<?> constructor = customClass.getConstructor(params);
                Object[] args = new Object[]{state};
                stateAdapter = (StateAdapter)constructor.newInstance(args);
            }
            catch (Exception e) {
                throw SwingXMLBuilder.createException("could not create StateAdapter for class " + customClass + " with state argument " + state, e, pElement);
            }
        } else if ("editable".equals(type)) {
            stateAdapter = new SwingEditableAdapter(state);
        } else if ("enabled".equals(type)) {
            boolean deep = Boolean.valueOf(pElement.getAttributeValue("deep"));
            stateAdapter = new SwingEnabledAdapter(state, deep);
        } else if ("tableEnabled".equals(type)) {
            stateAdapter = new SwingJTableEnabledAdapter(state);
        } else if ("selected".equals(type)) {
            stateAdapter = new SwingSelectedAdapter(state);
        } else if ("visible".equals(type)) {
            stateAdapter = new SwingVisibleAdapter(state);
        } else if ("border".equals(type)) {
            Border border = VisualBuilderDelegate.getBorder(pElement.getChild("border"));
            stateAdapter = border == null ? new SwingBorderAdapter(state) : new SwingBorderAdapter(state, border);
        } else if ("background".equals(type)) {
            Color color = VisualBuilderDelegate.getColor(pElement, 0);
            stateAdapter = color == null ? new SwingBackgroundAdapter(state) : new SwingBackgroundAdapter(state, color);
        }
        if (stateAdapter == null) {
            throw SwingXMLBuilder.createException("unknown state adapter type " + type, pElement);
        }
        List<Element> adaptees = pElement.getChildren("adaptee");
        for (Element element : adaptees) {
            String id = element.getAttributeValue("ref");
            Object adaptee = pBuilder.getComponentByAnyName(id);
            if (adaptee == null) {
                adaptee = pBuilder.getNonVisualObject(id);
            }
            if (adaptee == null) {
                throw SwingXMLBuilder.createException("unknown adaptee " + id, pElement);
            }
            boolean invert = this.getInvertFlag(element);
            stateAdapter.add(adaptee, invert);
        }
        if (pId != null) {
            stateAdapter.setName(pId);
        }
        return stateAdapter;
    }

    private boolean getInvertFlag(Element pElement) {
        boolean invert = false;
        if (pElement.getAttribute("invert") != null) {
            invert = "true".equals(pElement.getAttributeValue("invert"));
        }
        return invert;
    }

    private State getState(Element pElement, SwingXMLBuilder pBuilder, String pAttributeName) {
        String refId = pElement.getAttributeValue(pAttributeName);
        Object ref = pBuilder.getNonVisualObject(refId);
        if (!(ref instanceof State)) {
            throw SwingXMLBuilder.createException("ref " + refId + " is no state", pElement);
        }
        return (State)ref;
    }

    private void setState(Element pElement, String pId, SwingXMLBuilder pBuilder) throws IllegalArgumentException {
        Object ref = pBuilder.getNonVisualObject(pId);
        if (!(ref instanceof MutableState)) {
            throw SwingXMLBuilder.createException("state " + pId + " is not a mutable state", pElement);
        }
        String enabled = pElement.getAttributeValue("enabled");
        MutableState mutableState = (MutableState)ref;
        mutableState.setEnabled("true".equals(enabled));
    }
}

