/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class SwingMapping {
    private static final String SEPARATOR = "/";
    private JComponent mRoot;
    private Map<String, JComponent> mNameToComponent;
    private Map<String, JComponent> mShortNameToComponent;
    private Map<JComponent, String> mComponentToName;

    public static SwingMapping createMapping(JComponent pRoot) {
        if (pRoot == null) {
            throw new IllegalArgumentException("SwingMapping.createMapping(): pRoot must not be null");
        }
        SwingMapping mapping = new SwingMapping(pRoot);
        mapping.addMapping("", pRoot);
        return mapping;
    }

    public JComponent getComponentByName(String pName) {
        String name;
        if (pName == null) {
            return null;
        }
        if (!pName.contains("..")) {
            name = pName;
        } else {
            StringTokenizer tokenizer = new StringTokenizer(pName, SEPARATOR);
            ArrayList<String> list = new ArrayList<String>(tokenizer.countTokens());
            int stackCount = 0;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if ("..".equals(token)) {
                    if (--stackCount < 0) {
                        throw new IllegalArgumentException(pName + ": contains more ..'s than elements");
                    }
                    list.remove(stackCount);
                    continue;
                }
                list.add(token);
                ++stackCount;
            }
            StringBuilder nameBuffer = new StringBuilder();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                nameBuffer.append((String)list.get(i));
                if (i >= n - 1) continue;
                nameBuffer.append(SEPARATOR);
            }
            name = nameBuffer.toString();
        }
        return this.mNameToComponent.get(name);
    }

    public JComponent getByShortName(String pName) {
        return this.mShortNameToComponent.get(pName);
    }

    public String getNameByComponent(JComponent pComponent) {
        if (!SwingUtilities.isDescendingFrom(pComponent, this.mRoot)) {
            throw new IllegalArgumentException(pComponent + " doesn't descend from " + this.mRoot);
        }
        return this.mComponentToName.get(pComponent);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, JComponent> entry : this.mNameToComponent.entrySet()) {
            sb.append(entry.getKey());
            sb.append(" = ");
            sb.append(entry.getValue().getClass().getName());
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    private SwingMapping(JComponent pRoot) {
        this.mRoot = pRoot;
        this.mNameToComponent = new HashMap<String, JComponent>();
        this.mShortNameToComponent = new HashMap<String, JComponent>();
        this.mComponentToName = new HashMap<JComponent, String>();
    }

    private void addMapping(String pPrefix, JComponent pNode) {
        String myName = pNode.getName();
        Component[] children = pNode.getComponents();
        boolean hasName = myName != null;
        boolean isScrollPane = pNode instanceof JViewport;
        if ((hasName || isScrollPane) && children != null) {
            String newPrefix;
            if (isScrollPane) {
                newPrefix = pPrefix;
            } else {
                String fullName = pPrefix + myName;
                if (this.mNameToComponent.containsKey(fullName)) {
                    throw new IllegalArgumentException("SwingMapping: name inconsistancy detected for " + fullName);
                }
                this.mNameToComponent.put(fullName, pNode);
                this.mShortNameToComponent.put(myName, pNode);
                this.mComponentToName.put(pNode, fullName);
                newPrefix = fullName + SEPARATOR;
            }
            for (Component aChildren : children) {
                if (!(aChildren instanceof JComponent)) continue;
                this.addMapping(newPrefix, (JComponent)aChildren);
            }
        }
    }
}

