/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.ui;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FlexibleGridLayout
implements LayoutManager2 {
    private static final String DEFAULT_DATA_COLSPEC = "fill:pref:grow";
    private static final String DEFAULT_COL_GAP = "10dlu";
    public static final String LINE_BREAK = "LINE_BREAK";
    public static final String NO_LINE_BREAK = "NO_LINE_BREAK";
    private DefaultFormBuilder mBuilder;
    private boolean mAutoColumnBreakMode = false;

    public FlexibleGridLayout(JPanel panel) {
        this.init(panel);
    }

    private void init(JPanel panel) {
        this.mBuilder = new DefaultFormBuilder(new FormLayout("", ""), panel);
    }

    public void setDefaultBreak(int pDefaultBreak) {
        StringBuilder columnBuffer = new StringBuilder();
        for (int i = 0; i < pDefaultBreak; ++i) {
            String prefix = i == 0 ? "" : ",";
            columnBuffer.append(prefix).append("fill:pref:grow, 10dlu");
        }
        if (pDefaultBreak == 0) {
            columnBuffer.append(DEFAULT_DATA_COLSPEC);
        }
        this.mBuilder = new DefaultFormBuilder(new FormLayout(columnBuffer.toString(), ""), this.mBuilder.getPanel());
        this.mAutoColumnBreakMode = true;
    }

    @Override
    public void addLayoutComponent(String pName, Component pComponent) {
        this.addLayoutComponent(pComponent, pName);
    }

    @Override
    public void addLayoutComponent(Component pComponent, Object pConstraints) {
        if (pConstraints == null) {
            if (!this.mAutoColumnBreakMode) {
                this.ensureEnoughColumnsForNewComp();
            }
            this.mBuilder.append(pComponent);
        } else if (NO_LINE_BREAK.equals(pConstraints)) {
            if (!this.mAutoColumnBreakMode) {
                this.ensureEnoughColumnsForNewComp();
            }
            this.mBuilder.append(pComponent);
        } else if (LINE_BREAK.equals(pConstraints)) {
            if (this.mBuilder.getColumn() < this.mBuilder.getColumnCount()) {
                this.mBuilder.append(pComponent, this.mBuilder.getColumnCount() - this.mBuilder.getColumn());
            } else {
                this.ensureEnoughColumnsForNewComp();
                this.mBuilder.append(pComponent);
            }
            this.mBuilder.nextLine();
        } else {
            if (pComponent instanceof JScrollPane || !(pComponent instanceof JPanel) || this.containsScrollPane((JPanel)pComponent)) {
                // empty if block
            }
            this.mBuilder.getLayout().addLayoutComponent(pComponent, pConstraints);
        }
    }

    private boolean containsScrollPane(JPanel panel) {
        Component[] components;
        for (Component component : components = panel.getComponents()) {
            if (!(component instanceof JScrollPane)) continue;
            return true;
        }
        return false;
    }

    private void ensureEnoughColumnsForNewComp() {
        if (this.mBuilder.getColumn() > this.mBuilder.getColumnCount()) {
            this.mBuilder.appendColumn(DEFAULT_DATA_COLSPEC);
            this.mBuilder.appendColumn(DEFAULT_COL_GAP);
        }
    }

    @Override
    public void removeLayoutComponent(Component pComponent) {
        this.mBuilder.getLayout().removeLayoutComponent(pComponent);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.mBuilder.getLayout().layoutContainer(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.mBuilder.getLayout().minimumLayoutSize(parent);
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return this.mBuilder.getLayout().maximumLayoutSize(parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container pParent) {
        return this.mBuilder.getLayout().preferredLayoutSize(pParent);
    }

    @Override
    public void invalidateLayout(Container pTarget) {
        this.mBuilder.getLayout().invalidateLayout(pTarget);
    }

    @Override
    public float getLayoutAlignmentX(Container pTarget) {
        return this.mBuilder.getLayout().getLayoutAlignmentX(pTarget);
    }

    @Override
    public float getLayoutAlignmentY(Container pTarget) {
        return this.mBuilder.getLayout().getLayoutAlignmentY(pTarget);
    }

    public void setVgap(int pDluGapSize) {
        this.mBuilder.setLineGapSize(Sizes.dluY(pDluGapSize));
    }
}

