/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.state.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.cuf.state.ui.AbstractSwingState;

public class SwingListSelectionState
extends AbstractSwingState
implements ListSelectionListener,
ActionListener {
    public static final int NO_SELECTION = -1;
    private ListSelectionModel mListSelectionModel;
    private JComboBox mComboBox;
    private int mListIndex;

    public SwingListSelectionState(JList pList) {
        this(pList, -1);
    }

    public SwingListSelectionState(JList pList, int pIndex) {
        if (pList == null) {
            throw new IllegalArgumentException("JList must not be null");
        }
        this.init(pList.getSelectionModel(), pIndex);
    }

    public SwingListSelectionState(JTable pTable) {
        this(pTable, -1);
    }

    public SwingListSelectionState(JTable pTable, int pIndex) {
        if (pTable == null) {
            throw new IllegalArgumentException("JTable must not be null");
        }
        this.init(pTable.getSelectionModel(), pIndex);
    }

    public SwingListSelectionState(ListSelectionModel pSelectionModel, int pIndex) {
        this.init(pSelectionModel, pIndex);
    }

    public SwingListSelectionState(JComboBox pComboBox) {
        this(pComboBox, -1);
    }

    public SwingListSelectionState(JComboBox pComboBox, int pIndex) {
        if (pComboBox == null) {
            throw new IllegalArgumentException("JComboBox must not be null");
        }
        this.init(pComboBox, pIndex);
    }

    private void init(ListSelectionModel pSelectionModel, int pIndex) {
        if (pSelectionModel == null) {
            throw new IllegalArgumentException("list selection must not be null");
        }
        this.checkIndex(pIndex);
        this.mListIndex = pIndex;
        this.mListSelectionModel = pSelectionModel;
        this.mComboBox = null;
        this.mIsEnabled = this.getInternalState();
        this.mListSelectionModel.addListSelectionListener(this);
    }

    private void init(JComboBox pComboBox, int pIndex) {
        this.checkIndex(pIndex);
        this.mListIndex = pIndex;
        this.mListSelectionModel = null;
        this.mComboBox = pComboBox;
        this.mIsEnabled = this.getInternalState();
        this.mComboBox.addActionListener(this);
    }

    private void checkIndex(int pIndex) throws IllegalArgumentException {
        if (pIndex < -1) {
            throw new IllegalArgumentException("index must be >= -1");
        }
    }

    public void setCompareContent(int pIndex) {
        this.checkIndex(pIndex);
        this.mListIndex = pIndex;
        this.checkStateChange();
    }

    @Override
    public void valueChanged(ListSelectionEvent pEvent) {
        if (pEvent.getValueIsAdjusting()) {
            return;
        }
        this.checkStateChange();
    }

    @Override
    public void actionPerformed(ActionEvent pEvent) {
        this.checkStateChange();
    }

    @Override
    protected boolean getInternalState() {
        if (this.mListSelectionModel != null) {
            if (this.mListIndex == -1 && this.mListSelectionModel.isSelectionEmpty()) {
                return true;
            }
            return this.mListSelectionModel.isSelectedIndex(this.mListIndex);
        }
        return this.mListIndex == this.mComboBox.getSelectedIndex();
    }

    @Override
    protected void setReason() {
        this.mReason = this.mListSelectionModel;
    }
}

