/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.state.ui;

import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.sf.cuf.state.State;
import net.sf.cuf.state.ui.AbstractSwingState;

public class SwingListModelFillState
extends AbstractSwingState
implements State,
ListDataListener {
    private ListModel mListModel;
    private int mThreshold;

    public SwingListModelFillState(JList pList) {
        this(pList, 1);
    }

    public SwingListModelFillState(JList pList, int pThreshold) {
        if (pList == null) {
            throw new IllegalArgumentException("JList must not be null");
        }
        this.init(pList.getModel(), pThreshold);
    }

    public SwingListModelFillState(ListModel pModel, int pThreshold) {
        this.init(pModel, pThreshold);
    }

    private void init(ListModel pModel, int pThreshold) {
        if (pModel == null) {
            throw new IllegalArgumentException("list model must not be null");
        }
        this.mListModel = pModel;
        this.mThreshold = pThreshold;
        this.mIsEnabled = this.getInternalState();
        this.mListModel.addListDataListener(this);
    }

    @Override
    public void contentsChanged(ListDataEvent pEvent) {
        this.checkStateChange();
    }

    @Override
    public void intervalAdded(ListDataEvent pEvent) {
        this.checkStateChange();
    }

    @Override
    public void intervalRemoved(ListDataEvent pEvent) {
        this.checkStateChange();
    }

    @Override
    protected boolean getInternalState() {
        return this.mListModel.getSize() >= this.mThreshold;
    }

    @Override
    protected void setReason() {
        this.mReason = this.mListModel;
    }
}

