/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.state.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import net.sf.cuf.state.AbstractStateAdapter;
import net.sf.cuf.state.State;

public class SwingGlassPaneAdapter
extends AbstractStateAdapter {
    public SwingGlassPaneAdapter() {
    }

    public SwingGlassPaneAdapter(State pState) {
        super(pState);
    }

    @Override
    protected void adjustInitialState(Object pTarget, boolean pEnabled) {
        if (pTarget instanceof RootPaneContainer && pTarget instanceof Window) {
            RootPaneContainer target = (RootPaneContainer)pTarget;
            if (!(target.getGlassPane() instanceof GlassPane)) {
                target.setGlassPane(new GlassPane());
            }
        } else {
            throw new IllegalStateException("we cant handle that object:" + pTarget);
        }
        this.processStateChange(pTarget, pEnabled);
    }

    @Override
    protected void processStateChange(Object pTarget, boolean pEnabled) {
        GlassPane glassPane = (GlassPane)((RootPaneContainer)pTarget).getGlassPane();
        Window target = (Window)pTarget;
        if (pEnabled && !glassPane.isVisible()) {
            glassPane.mLastFocusOwner = target.getFocusOwner();
            glassPane.mLastCursor = target.getCursor();
            target.setCursor(Cursor.getPredefinedCursor(3));
            glassPane.setVisible(true);
            glassPane.requestFocus();
        } else if (!pEnabled && glassPane.isVisible()) {
            target.setCursor(glassPane.mLastCursor);
            glassPane.setVisible(false);
            if (glassPane.mLastFocusOwner != null) {
                glassPane.mLastFocusOwner.requestFocus();
            }
        }
    }

    private static class GlassPane
    extends JComponent {
        private Component mLastFocusOwner;
        private Cursor mLastCursor;

        public GlassPane() {
            this.addMouseListener(new MouseAdapter(){});
            this.setNextFocusableComponent(this);
        }

        @Override
        protected void processKeyEvent(KeyEvent pEvent) {
            pEvent.consume();
        }
    }
}

