/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.state.ui;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import net.sf.cuf.state.AbstractStateAdapter;
import net.sf.cuf.state.State;

public class SwingBorderAdapter
extends AbstractStateAdapter {
    private Border mDisabledBorder;
    private Map<JComponent, Border> mOriginalBorder;

    public SwingBorderAdapter(State pState) {
        super(pState);
        LineBorder disabledBorder = new LineBorder(UIManager.getColor("ComboBox.disabledForeground"));
        this.init(disabledBorder);
    }

    public SwingBorderAdapter(Border pDisabledBorder) {
        this.init(pDisabledBorder);
    }

    public SwingBorderAdapter(State pState, Border pDisabledBorder) {
        super(pState);
        this.init(pDisabledBorder);
    }

    private void init(Border pDisabledBorder) {
        if (pDisabledBorder == null) {
            throw new IllegalArgumentException("Border must not be null");
        }
        this.mOriginalBorder = new HashMap<JComponent, Border>(1);
        this.mDisabledBorder = pDisabledBorder;
    }

    public void setBorder(Border pDisabledBorder) {
        if (pDisabledBorder == null) {
            throw new IllegalArgumentException("Border must not be null");
        }
        this.mDisabledBorder = pDisabledBorder;
    }

    @Override
    protected void adjustInitialState(Object pTarget, boolean pEnabled) {
        if (!(pTarget instanceof JComponent)) {
            throw new IllegalStateException("we cant handle that object:" + pTarget);
        }
        JComponent component = (JComponent)pTarget;
        this.mOriginalBorder.put(component, component.getBorder());
        this.processStateChange(pTarget, pEnabled);
    }

    @Override
    protected void processStateChange(Object pTarget, boolean pEnabled) {
        if (pTarget instanceof JComponent) {
            JComponent component = (JComponent)pTarget;
            if (pEnabled) {
                component.setBorder(this.mOriginalBorder.get(component));
            } else {
                component.setBorder(this.mDisabledBorder);
            }
        } else {
            throw new IllegalStateException("we cant handle that object:" + pTarget);
        }
    }
}

