/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.state.ui;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import net.sf.cuf.state.AbstractStateAdapter;
import net.sf.cuf.state.State;

public class SwingBackgroundAdapter
extends AbstractStateAdapter {
    private Color mDisabledColor;
    private Map<JComponent, Color> mOriginalBackground;

    public SwingBackgroundAdapter(State pState) {
        super(pState);
        Color disabledColor = Color.PINK;
        this.init(disabledColor);
    }

    public SwingBackgroundAdapter(Color pDisabledColor) {
        this.init(pDisabledColor);
    }

    public SwingBackgroundAdapter(State pState, Color pDisabledColor) {
        super(pState);
        this.init(pDisabledColor);
    }

    private void init(Color pDisabledColor) {
        if (pDisabledColor == null) {
            throw new IllegalArgumentException("Color must not be null");
        }
        this.mOriginalBackground = new HashMap<JComponent, Color>(1);
        this.mDisabledColor = pDisabledColor;
    }

    public void setDisabledBackgound(Color pDisabledColor) {
        if (pDisabledColor == null) {
            throw new IllegalArgumentException("Color must not be null");
        }
        this.mDisabledColor = pDisabledColor;
    }

    @Override
    protected void adjustInitialState(Object pTarget, boolean pEnabled) {
        if (!(pTarget instanceof JComponent)) {
            throw new IllegalStateException("we cant handle that object:" + pTarget);
        }
        JComponent component = (JComponent)pTarget;
        this.mOriginalBackground.put(component, component.getBackground());
        this.processStateChange(pTarget, pEnabled);
    }

    @Override
    protected void processStateChange(Object pTarget, boolean pEnabled) {
        if (pTarget instanceof JComponent) {
            JComponent component = (JComponent)pTarget;
            if (pEnabled) {
                component.setBackground(this.mOriginalBackground.get(component));
            } else {
                component.setBackground(this.mDisabledColor);
            }
        } else {
            throw new IllegalStateException("we cant handle that object:" + pTarget);
        }
    }
}

