/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model.converter;

import java.math.BigDecimal;
import java.text.NumberFormat;
import net.sf.cuf.model.ValueModel;
import net.sf.cuf.model.converter.AbstractTypeConverter;
import net.sf.cuf.model.converter.ConversionException;
import net.sf.cuf.model.converter.TypeConverter;

public class BigDecimalStringConverter
extends AbstractTypeConverter<String, BigDecimal>
implements TypeConverter<String, BigDecimal> {
    private boolean mNullIsValid;
    private NumberFormat mFormat;
    private BigDecimal mNullSubstitute;

    public BigDecimalStringConverter(ValueModel<BigDecimal> pSubject) {
        this(pSubject, null, true);
    }

    public BigDecimalStringConverter(ValueModel<BigDecimal> pSubject, boolean pNullIsValid) {
        this(pSubject, null, pNullIsValid);
    }

    public BigDecimalStringConverter(ValueModel<BigDecimal> pSubject, NumberFormat pFormat) {
        this(pSubject, pFormat, true);
    }

    public BigDecimalStringConverter(ValueModel<BigDecimal> pSubject, NumberFormat pFormat, boolean pNullIsValid) {
        super(pSubject);
        this.mNullIsValid = pNullIsValid;
        this.mFormat = pFormat;
    }

    public void setNullSubstitute(BigDecimal pNullSubstitute) {
        if (!this.mNullIsValid) {
            throw new IllegalStateException("null substitute " + pNullSubstitute + " set but null is not valid at all");
        }
        this.mNullSubstitute = pNullSubstitute;
    }

    @Override
    public String convertSubjectToOwnValue(BigDecimal pSubjectValue) throws ConversionException {
        if (pSubjectValue == null) {
            if (this.mNullIsValid) {
                throw new ConversionException("BigDecimal subject is null", null, null);
            }
            throw new ConversionException("BigDecimal subject is null and !mNullIsValid", null);
        }
        String ownValue = this.mFormat != null ? this.mFormat.format(pSubjectValue.doubleValue()) : pSubjectValue.toString();
        return ownValue;
    }

    @Override
    public BigDecimal convertOwnToSubjectValue(String pOwnValue) throws ConversionException {
        BigDecimal subjectValue;
        String ownValue = pOwnValue;
        try {
            subjectValue = this.mFormat != null ? (BigDecimal)this.mFormat.parse(ownValue) : new BigDecimal(ownValue);
        }
        catch (Exception e) {
            if (this.mNullIsValid) {
                throw new ConversionException(e.getMessage(), e, this.mNullSubstitute);
            }
            throw new ConversionException(e.getMessage(), e);
        }
        return subjectValue;
    }
}

