/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.model;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.cuf.model.AspectAccessAdapter;

public class MixedAccessAdapter
implements AspectAccessAdapter {
    private String[] mAspectNames;
    private Method[] mGetMethods;
    private Method mSetMethod;
    private String mGetPrefix;
    private String mSetPrefix;
    private static final Class[] NO_PARAMS = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];

    public MixedAccessAdapter(String pAspectName) {
        this(pAspectName, "get", "set");
    }

    public MixedAccessAdapter(Class pSourceClass, String pAspectName) {
        this(pSourceClass, pAspectName, "get", "set");
    }

    public MixedAccessAdapter(String pAspectName, String pGetterPrefix, String pSetterPrefix) {
        this(null, pAspectName, pGetterPrefix, pSetterPrefix);
    }

    public MixedAccessAdapter(Class pSourceClass, String pAspectName, String pGetterPrefix, String pSetterPrefix) {
        if (pGetterPrefix == null) {
            throw new IllegalArgumentException("GetterPrefix must not be null");
        }
        if (pSetterPrefix == null) {
            throw new IllegalArgumentException("SetterPrefix must not be null");
        }
        if (pGetterPrefix.length() == 0) {
            throw new IllegalArgumentException("GetterPrefix must not be empty");
        }
        if (pSetterPrefix.length() == 0) {
            throw new IllegalArgumentException("SetterPrefix must not be empty");
        }
        if (pSetterPrefix.equals(pGetterPrefix)) {
            throw new IllegalArgumentException("get and set prefix must differ");
        }
        this.mGetPrefix = pGetterPrefix;
        this.mSetPrefix = pSetterPrefix;
        StringTokenizer st = new StringTokenizer(pAspectName, ".");
        this.mGetMethods = new Method[st.countTokens()];
        this.mAspectNames = new String[this.mGetMethods.length];
        for (int i = 0; i < this.mGetMethods.length; ++i) {
            this.mAspectNames[i] = st.nextToken();
        }
        if (pSourceClass != null && !Map.class.isAssignableFrom(pSourceClass)) {
            String getterName = this.mGetPrefix + this.mAspectNames[0].substring(0, 1).toUpperCase() + this.mAspectNames[0].substring(1);
            try {
                pSourceClass.getMethod(getterName, NO_PARAMS);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Class " + pSourceClass + " does not have a method " + getterName + "(). " + "If you want to use late binding you must not provide a source class.");
            }
        }
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public Object getValue(Object pSource) {
        if (pSource == null) {
            return null;
        }
        Object aspect = pSource;
        for (int i = 0; i < this.mAspectNames.length; ++i) {
            String aspectName = this.mAspectNames[i];
            if (aspect == null) {
                return null;
            }
            if (aspect instanceof Map) {
                Map source = (Map)aspect;
                aspect = source.get(aspectName);
                continue;
            }
            aspect = this.getAspect(aspect, i, aspectName);
        }
        return aspect;
    }

    private Object getAspect(Object pAspect, int pI, String pAspectName) {
        Class<?> aspectClass = pAspect.getClass();
        if (this.mGetMethods[pI] == null || !this.mGetMethods[pI].getDeclaringClass().isAssignableFrom(aspectClass)) {
            Method getter;
            String getterName = this.mGetPrefix + pAspectName.substring(0, 1).toUpperCase() + pAspectName.substring(1);
            try {
                getter = aspectClass.getMethod(getterName, NO_PARAMS);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Class " + aspectClass + " does not have a method " + getterName + "()");
            }
            this.mGetMethods[pI] = getter;
        }
        try {
            pAspect = this.mGetMethods[pI].invoke(pAspect, NO_ARGS);
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("While extracting aspect " + pAspectName + " on object of class " + aspectClass + ": " + e.getMessage());
            iae.initCause(e.getCause());
            throw iae;
        }
        return pAspect;
    }

    @Override
    public void setValue(Object pSource, Object pValue) {
        Object aspect;
        Object source = aspect = pSource;
        for (int i = 0; i < this.mAspectNames.length; ++i) {
            String aspectName = this.mAspectNames[i];
            aspect = aspect instanceof Map ? ((Map)aspect).get(aspectName) : this.getAspect(aspect, i, aspectName);
            if (i != this.mAspectNames.length - 2) continue;
            source = aspect;
        }
        aspect = null;
        String lastAspectName = this.mAspectNames[this.mAspectNames.length - 1];
        if (source instanceof Map) {
            ((Map)source).put(lastAspectName, pValue);
        } else {
            Class<?> sourceClass = source.getClass();
            if (this.mSetMethod == null || !this.mSetMethod.getDeclaringClass().isAssignableFrom(sourceClass)) {
                String setterName = this.mSetPrefix + lastAspectName.substring(0, 1).toUpperCase() + lastAspectName.substring(1);
                Class<?> getterReturnClass = this.mGetMethods[this.mAspectNames.length - 1].getReturnType();
                try {
                    this.mSetMethod = sourceClass.getMethod(setterName, getterReturnClass);
                }
                catch (NoSuchMethodException e) {
                    StringBuilder sb = new StringBuilder("Class ");
                    sb.append(sourceClass.getName());
                    sb.append(" does not have a method ");
                    sb.append(setterName);
                    sb.append('(');
                    sb.append(getterReturnClass.getName());
                    sb.append(')');
                    throw new IllegalArgumentException(sb.toString());
                }
            }
            try {
                this.mSetMethod.invoke(source, pValue);
            }
            catch (Exception e) {
                IllegalArgumentException iae = new IllegalArgumentException("While setting aspect " + lastAspectName + " on object of class " + sourceClass + ": " + e.getMessage());
                iae.initCause(e.getCause());
                throw iae;
            }
        }
    }
}

