/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.fw;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Date;
import net.sf.cuf.fw.Application;

public class EDTExceptionUtil {
    private static Application sApplication;
    private static FatalErrorReporter sFatalErrorReporter;
    private static String sVersion;
    private static String sDumpPrefix;
    private static final String DUMP_FILE_PATH;
    private static final String DUMP_FILE_POSTFIX = "_dump.txt";

    public static void install() {
        System.setProperty("sun.awt.exception.handler", EDTExceptionUtil.class.getName());
    }

    public static void setFatalErrorReporter(FatalErrorReporter pFatalErrorReporter) {
        if (pFatalErrorReporter == null) {
            throw new IllegalArgumentException("pFatalErrorReporter must not be null");
        }
        sFatalErrorReporter = pFatalErrorReporter;
    }

    public static void setApp(Application pApp) {
        sApplication = pApp;
    }

    public static void setVersion(String pDumpPrefix, String pVersion) {
        sDumpPrefix = pDumpPrefix;
        sVersion = pVersion;
    }

    public void handle(Throwable pThrowable) {
        sFatalErrorReporter.reportFatalError(pThrowable);
        if (sApplication != null) {
            sApplication.doStop();
        }
        System.err.println("could not stop application");
    }

    static {
        sFatalErrorReporter = new DefaultFatalErrorReporter();
        DUMP_FILE_PATH = System.getProperty("user.home") + System.getProperty("file.separator");
    }

    public static class DefaultFatalErrorReporter
    implements FatalErrorReporter {
        @Override
        public void reportFatalError(Throwable pThrowable) {
            String message = "caught an unexpected exception on " + new Date() + " in the EventDispatchThread:";
            System.err.println(message);
            pThrowable.printStackTrace(System.err);
            try {
                String dumpFileName = sDumpPrefix != null ? DUMP_FILE_PATH + sDumpPrefix + EDTExceptionUtil.DUMP_FILE_POSTFIX : DUMP_FILE_PATH + "unknown" + EDTExceptionUtil.DUMP_FILE_POSTFIX;
                FileOutputStream fout = new FileOutputStream(dumpFileName);
                PrintWriter out = new PrintWriter(fout);
                out.println(sVersion);
                out.println(message);
                pThrowable.printStackTrace(out);
                out.close();
                fout.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface FatalErrorReporter {
        public void reportFatalError(Throwable var1);
    }
}

