/*
 * Decompiled with CFR 0.152.
 */
package olg.csv.bean.annotations.processor;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import olg.csv.base.csv.CSVSettings;
import olg.csv.base.ods.ODSSettings;
import olg.csv.bean.IBeanProcessor;
import olg.csv.bean.IPropertyProcessor;
import olg.csv.bean.IRowProcessor;
import olg.csv.bean.annotations.Column;
import olg.csv.bean.annotations.Embedded;
import olg.csv.bean.annotations.Param;
import olg.csv.bean.annotations.RowBean;
import olg.csv.bean.annotations.processor.AnnotationProcessorException;
import olg.csv.bean.annotations.processor.ColumnProcessor;
import olg.csv.bean.annotations.processor.EmbeddedProcessor;
import olg.csv.bean.impl.BeanProcessor;
import olg.csv.bean.impl.CellProcessor;
import olg.csv.bean.impl.RowProcessor;
import olg.csv.bean.parser.AbstractParser;
import olg.csv.bean.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RowBeanProcessor<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RowBeanProcessor.class);
    private ODSPropertyType[] ODSReadingProperties = ODSPropertyType.values();
    private ODSPropertyType[] ODSWritingProperties = new ODSPropertyType[]{ODSPropertyType.SHEETNAME, ODSPropertyType.BEGIN_AT_ROW, ODSPropertyType.BEGIN_AT_COLUMN, ODSPropertyType.HEADERS};
    private CSVPropertyType[] CSVReadingProperties = new CSVPropertyType[]{CSVPropertyType.DELIMITER, CSVPropertyType.SEPARATOR, CSVPropertyType.CHARSETNAME, CSVPropertyType.HEADERS};
    private CSVPropertyType[] CSVWritingProperties = new CSVPropertyType[]{CSVPropertyType.DELIMITER, CSVPropertyType.SEPARATOR, CSVPropertyType.CHARSETNAME, CSVPropertyType.LINE_SEPARATOR, CSVPropertyType.HEADERS};
    private Class<T> clazz;
    private ColumnProcessor<T> columnProcessor;
    private EmbeddedProcessor<T> embeddedProcessor;

    public RowBeanProcessor(Class<T> clazz) {
        this.clazz = clazz;
        this.columnProcessor = new ColumnProcessor<T>(clazz);
        this.embeddedProcessor = new EmbeddedProcessor<T>(clazz);
    }

    public boolean hasRowBeanAnnotation() {
        return this.clazz.getAnnotation(RowBean.class) != null;
    }

    public ODSSettings getReadingODSSettings() throws AnnotationProcessorException {
        RowBean rowBean = this.clazz.getAnnotation(RowBean.class);
        Param[] odsReadingParams = rowBean.ODSReadingParams();
        return this.getODSSettings(odsReadingParams, this.ODSReadingProperties, "ODSReadingParam");
    }

    public ODSSettings getWritingODSSettings() throws AnnotationProcessorException {
        RowBean rowBean = this.clazz.getAnnotation(RowBean.class);
        Param[] odsWritingParams = rowBean.ODSWritingParams();
        return this.getODSSettings(odsWritingParams, this.ODSWritingProperties, "ODSWritingParam");
    }

    public CSVSettings getReadingCSVSettings() throws AnnotationProcessorException {
        RowBean rowBean = this.clazz.getAnnotation(RowBean.class);
        Param[] csvReadinggParams = rowBean.CSVReadingParams();
        return this.getCSVSettings(csvReadinggParams, this.CSVReadingProperties, "CSVReadingParam");
    }

    public CSVSettings getWritingCSVSettings() throws AnnotationProcessorException {
        RowBean rowBean = this.clazz.getAnnotation(RowBean.class);
        Param[] csvWritingParams = rowBean.CSVWritingParams();
        return this.getCSVSettings(csvWritingParams, this.CSVWritingProperties, "CSVWritingParam");
    }

    public IBeanProcessor<T> getBeanProcessor() throws AnnotationProcessorException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        ArrayList<IPropertyProcessor<T>> propertyProcessors = new ArrayList<IPropertyProcessor<T>>();
        boolean noError = this.getReadingProcessor(0, propertyProcessors, map);
        BeanProcessor beanProcessor = new BeanProcessor(this.clazz);
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            LOGGER.error("For column {}, {} fields match. Only one is supported", entry.getKey(), entry.getValue());
            noError = false;
        }
        if (noError) {
            beanProcessor.addAll(propertyProcessors);
            return beanProcessor;
        }
        throw new AnnotationProcessorException("Some error occured on BeanProcessor loading. See logs for more details");
    }

    public IRowProcessor<T> getRowProcessor() throws AnnotationProcessorException {
        HashMap<Integer, List<CellProcessor<T>>> map = new HashMap<Integer, List<CellProcessor<T>>>();
        boolean noError = this.getWritingProcessor(map);
        ArrayList cellProcessors = new ArrayList();
        if (noError) {
            for (Map.Entry entry : map.entrySet()) {
                if (((List)entry.getValue()).size() > 1) {
                    LOGGER.error("For column {}, {} fields match. Only one is supported", entry.getKey(), (Object)((List)entry.getValue()).size());
                    noError = false;
                    continue;
                }
                cellProcessors.add(((List)entry.getValue()).iterator().next());
            }
        }
        if (noError) {
            return new RowProcessor(cellProcessors);
        }
        throw new AnnotationProcessorException("Some error occured on RowProcessor loading. See logs for more details");
    }

    protected boolean getWritingProcessor(Map<Integer, List<CellProcessor<T>>> map) {
        if (this.hasRowBeanAnnotation()) {
            return this.getWritingProcessor(this.clazz, map);
        }
        LOGGER.error("@RowBean Annotation not found on {} class", (Object)this.clazz.getSimpleName());
        return false;
    }

    protected boolean getReadingProcessor(int translate, List<IPropertyProcessor<T>> processors, Map<Integer, Integer> map) {
        if (this.hasRowBeanAnnotation()) {
            return this.getReadingProcessor(this.clazz, translate, processors, map);
        }
        LOGGER.error("@RowBean Annotation not found on {} class", (Object)this.clazz.getSimpleName());
        return false;
    }

    private boolean getWritingProcessor(Class<? super T> beanClass, Map<Integer, List<CellProcessor<T>>> map) {
        boolean noError = true;
        if (beanClass.getAnnotation(RowBean.class) != null) {
            Field[] fields;
            if (beanClass.getSuperclass() != null) {
                noError &= this.getWritingProcessor(beanClass.getSuperclass(), map);
            }
            for (Field field : fields = beanClass.getDeclaredFields()) {
                if (!this.checkField(field, beanClass)) {
                    noError = false;
                    continue;
                }
                noError &= this.columnProcessor.getWritingProcessor(field, map);
                noError &= this.embeddedProcessor.getWritingProcessor(field, map);
            }
        }
        return noError;
    }

    private boolean getReadingProcessor(Class<? super T> beanClass, int translate, List<IPropertyProcessor<T>> processors, Map<Integer, Integer> map) {
        Field[] fields;
        boolean noError = true;
        if (beanClass.getAnnotation(RowBean.class) != null && beanClass.getSuperclass() != null) {
            noError &= this.getReadingProcessor(beanClass.getSuperclass(), translate, processors, map);
        }
        for (Field field : fields = beanClass.getDeclaredFields()) {
            if (!this.checkField(field, beanClass)) {
                noError = false;
                continue;
            }
            noError &= this.columnProcessor.getReadingProcessor(translate, field, processors, map);
            noError &= this.embeddedProcessor.getReadingProcessor(translate, field, processors, map);
        }
        return noError;
    }

    private boolean checkField(Field field, Class<? super T> beanClass) {
        if (field.getAnnotation(Column.class) != null && field.getAnnotation(Embedded.class) != null) {
            LOGGER.error("{}.{} : A field must not have both the column annotation and the embedded annotation", (Object)beanClass.getSimpleName(), (Object)field.getName());
            return false;
        }
        return true;
    }

    private ODSPropertyType identifyPermittedProperty(Param param, ODSPropertyType[] permittedProperties) {
        ODSPropertyType propertyType = ODSPropertyType.getByCode(param.name());
        if (propertyType != null) {
            boolean find = false;
            for (ODSPropertyType permittedProperty : permittedProperties) {
                if (propertyType != permittedProperty) continue;
                find = true;
                break;
            }
            propertyType = find ? propertyType : null;
        }
        return propertyType;
    }

    private ODSSettings getODSSettings(Param[] odsParams, ODSPropertyType[] properties, String type) throws AnnotationProcessorException {
        ODSSettings settings = new ODSSettings();
        boolean exceptionOnProcess = false;
        if (odsParams != null && odsParams.length > 0) {
            for (Param param : odsParams) {
                ODSPropertyType propertyType = this.identifyPermittedProperty(param, properties);
                if (propertyType != null) {
                    if ("".equals(param.value())) {
                        LOGGER.warn("{}@RowBean : empty string  is not a legal value for {} {}", new Object[]{this.clazz.getSimpleName(), param.name(), type});
                        continue;
                    }
                    try {
                        propertyType.setParam(settings, param.value());
                    }
                    catch (AnnotationProcessorException ex) {
                        exceptionOnProcess = true;
                    }
                    continue;
                }
                LOGGER.warn("{}@RowBean : {} is not a legal {}, it will be ignored", new Object[]{this.clazz.getSimpleName(), param.name(), type});
            }
        }
        if (exceptionOnProcess) {
            throw new AnnotationProcessorException("See logs for more details");
        }
        return settings;
    }

    private CSVPropertyType identifyPermittedProperty(Param param, CSVPropertyType[] permittedProperties) {
        CSVPropertyType propertyType = CSVPropertyType.getByCode(param.name());
        if (propertyType != null) {
            boolean find = false;
            for (CSVPropertyType permittedProperty : permittedProperties) {
                if (propertyType != permittedProperty) continue;
                find = true;
                break;
            }
            propertyType = find ? propertyType : null;
        }
        return propertyType;
    }

    private CSVSettings getCSVSettings(Param[] csvParams, CSVPropertyType[] properties, String type) throws AnnotationProcessorException {
        CSVSettings settings = new CSVSettings();
        boolean exceptionOnProcess = false;
        if (csvParams != null && csvParams.length > 0) {
            for (Param param : csvParams) {
                CSVPropertyType propertyType = this.identifyPermittedProperty(param, properties);
                if (propertyType != null) {
                    if ("".equals(param.value())) {
                        LOGGER.warn("{}@RowBean : empty string  is not a legal value for {} {}", new Object[]{this.clazz.getSimpleName(), param.name(), type});
                        continue;
                    }
                    try {
                        propertyType.setParam(settings, param.value());
                    }
                    catch (AnnotationProcessorException ex) {
                        exceptionOnProcess = true;
                    }
                    continue;
                }
                LOGGER.warn("{}@RowBean : {} is not a legal {}, it will be ignored", new Object[]{this.clazz.getSimpleName(), param.name(), type});
            }
        }
        if (exceptionOnProcess) {
            throw new AnnotationProcessorException("See logs for more details");
        }
        return settings;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CSVPropertyType {
        HEADERS("headers", "withHeaders", new AbstractParser<Boolean>(){

            public Boolean parse(String str) {
                if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("false")) {
                    return Boolean.valueOf(str);
                }
                LOGGER.error("{} CSV Property only supports \"true\" or \"false\" value, not [{}]", (Object)"headers", (Object)str);
                throw new ParseException();
            }
        }),
        SEPARATOR("separator", "separator", new AbstractParser<Character>(){

            public Character parse(String str) {
                Character retour = null;
                if (str.trim().length() != 1) {
                    LOGGER.error("{} CSVProperty only supports String as char, not [{}]", (Object)"separator", (Object)str);
                    throw new ParseException();
                }
                retour = Character.valueOf(str.trim().charAt(0));
                return retour;
            }
        }),
        DELIMITER("delimiter", "delimiter", new AbstractParser<Character>(){

            public Character parse(String str) {
                Character retour = null;
                if (str.trim().length() != 1) {
                    LOGGER.error("{} CSVProperty only supports String as char, not [{}]", (Object)"separator", (Object)str);
                    throw new ParseException();
                }
                retour = Character.valueOf(str.trim().charAt(0));
                return retour;
            }
        }),
        CHARSETNAME("charset", "charsetName", null),
        LINE_SEPARATOR("lineSeparator", "lineSeparator", null);

        private String code;
        private AbstractParser<?> parser;
        private Method setter;
        private String property;

        private CSVPropertyType(String code, String property, AbstractParser<?> parser) {
            this.code = code;
            this.parser = parser;
            this.property = property;
            Method[] methods = CSVSettings.class.getMethods();
            String setterName = "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
            for (Method methode : methods) {
                if (!methode.getName().equals(setterName) || methode.getParameterTypes().length != 1) continue;
                this.setter = methode;
                break;
            }
        }

        public static CSVPropertyType getByCode(String code) {
            CSVPropertyType retour = null;
            for (CSVPropertyType type : CSVPropertyType.values()) {
                if (!type.code.equals(code)) continue;
                retour = type;
                break;
            }
            return retour;
        }

        public CSVSettings setParam(CSVSettings settings, String value) throws AnnotationProcessorException {
            try {
                this.setter.invoke((Object)settings, this.parser != null ? this.parser.parse(value) : value);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Hmm, I thought it couldn't happen", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Hmm, I thought it couldn't happen", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("CSVSettings error on {} setting ", (Object)this.property, (Object)e.getTargetException());
                throw new AnnotationProcessorException();
            }
            catch (ParseException e) {
                throw new AnnotationProcessorException();
            }
            return settings;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ODSPropertyType {
        HEADERS("headers", "withHeaders", new AbstractParser<Boolean>(){

            public Boolean parse(String str) {
                if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("false")) {
                    return Boolean.valueOf(str);
                }
                LOGGER.error("{} ODS Property only supports \"true\" or \"false\" value", (Object)"headers");
                throw new ParseException();
            }
        }),
        SHEETNUM("sheetNum", "sheetNum", new AbstractParser<Integer>(){

            public Integer parse(String str) {
                try {
                    return Integer.valueOf(str);
                }
                catch (NumberFormatException ex) {
                    LOGGER.error("{} ODS Property only supports integer value", (Object)"sheetNum");
                    throw new ParseException();
                }
            }
        }),
        SHEETNAME("sheetName", "sheetName", null),
        BEGIN_AT_ROW("beginAtRow", "beginAtRow", new AbstractParser<Integer>(){

            public Integer parse(String str) {
                try {
                    return Integer.valueOf(str);
                }
                catch (NumberFormatException ex) {
                    LOGGER.error("{} ODS Property only supports integer value", (Object)"beginAtRow");
                    throw new ParseException();
                }
            }
        }),
        END_AT_ROW("endAtRow", "endAtRow", new AbstractParser<Integer>(){

            public Integer parse(String str) {
                try {
                    return Integer.valueOf(str);
                }
                catch (NumberFormatException ex) {
                    LOGGER.error("{} ODS Property only supports integer value", (Object)"endAtRow");
                    throw new ParseException();
                }
            }
        }),
        BEGIN_AT_COLUMN("beginAtColumn", "beginAtColumn", null),
        END_AT_COLUMN("endAtColumn", "endAtColumn", null);

        private String code;
        private AbstractParser<?> parser;
        private Method setter;
        private String property;

        private ODSPropertyType(String code, String property, AbstractParser<?> parser) {
            this.code = code;
            this.parser = parser;
            this.property = property;
            Method[] methods = ODSSettings.class.getMethods();
            String setterName = "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
            for (Method methode : methods) {
                if (!methode.getName().equals(setterName) || methode.getParameterTypes().length != 1) continue;
                this.setter = methode;
                break;
            }
        }

        static ODSPropertyType getByCode(String code) {
            ODSPropertyType retour = null;
            for (ODSPropertyType type : ODSPropertyType.values()) {
                if (!type.code.equals(code)) continue;
                retour = type;
                break;
            }
            return retour;
        }

        ODSSettings setParam(ODSSettings settings, String value) throws AnnotationProcessorException {
            try {
                this.setter.invoke((Object)settings, this.parser != null ? this.parser.parse(value) : value);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Hmm, I thought it couldn't happen", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("Hmm, I thought it couldn't happen", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("ODSSettings error on {} setting ", (Object)this.property, (Object)e.getTargetException());
                throw new AnnotationProcessorException();
            }
            catch (ParseException e) {
                throw new AnnotationProcessorException();
            }
            return settings;
        }
    }
}

