/*
 * Decompiled with CFR 0.152.
 */
package olg.csv.bean.annotations.processor;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.Date;
import java.util.Locale;
import olg.csv.base.UsageInvalideException;
import olg.csv.bean.Util;
import olg.csv.bean.annotations.Param;
import olg.csv.bean.annotations.Parser;
import olg.csv.bean.annotations.processor.AnnotationProcessorException;
import olg.csv.bean.parser.AbstractParser;
import olg.csv.bean.parser.ParseException;
import olg.csv.bean.parser.impl.DateParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParserProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParserProcessor.class);
    private static ParserProcessor instance = new ParserProcessor();

    private ParserProcessor() {
    }

    public static ParserProcessor getInstance() {
        return instance;
    }

    public <T> AbstractParser<T> getParser(Field field, Class<T> fieldConcreteClass) throws AnnotationProcessorException {
        Object parser = null;
        Parser parserAnnotation = field.getAnnotation(Parser.class);
        if (parserAnnotation != null) {
            Class<AbstractParser<?>> clazz = parserAnnotation.value();
            parser = clazz.equals(DateParser.class) ? this.getDateParser(field, parserAnnotation, fieldConcreteClass) : this.getCustomParser(field, parserAnnotation, fieldConcreteClass);
        } else {
            try {
                parser = AbstractParser.identifyDefaultParser(fieldConcreteClass);
            }
            catch (UsageInvalideException ex) {
                LOGGER.error("{}@Column : can not identify a default {} parser : May be, use @Parser annotation ...", (Object)field.getName(), (Object)fieldConcreteClass.getSimpleName());
                throw new AnnotationProcessorException(ex);
            }
        }
        return parser;
    }

    private <T> AbstractParser<Date> getDateParser(Field field, Parser parserAnnotation, Class<T> fieldConcreteClass) throws AnnotationProcessorException {
        DateParser parser = null;
        String format = null;
        Locale locale = null;
        Class<Date> dateClass = null;
        boolean errorOccurs = false;
        try {
            dateClass = fieldConcreteClass.asSubclass(Date.class);
        }
        catch (ClassCastException ex) {
            errorOccurs = true;
            LOGGER.error("{}@Parser : {} field class must extend Date class to instanciate a DateParser", (Object)field.getName(), (Object)fieldConcreteClass.getSimpleName());
        }
        if (!Util.isConcrete(fieldConcreteClass)) {
            errorOccurs = true;
            LOGGER.error("{}@Parser : {} field class must be a concrete class", (Object)field.getName(), (Object)fieldConcreteClass.getSimpleName());
        }
        for (Param param : parserAnnotation.params()) {
            if (param.name().equals("format")) {
                format = param.value();
                continue;
            }
            if (param.name().equals("locale")) {
                locale = olg.csv.bean.loader.Util.getLocale((String)param.value());
                if (locale != null) continue;
                LOGGER.warn("{}@Parser : {} Locale property is not an available Locale, it will be ignored", (Object)field.getName(), (Object)param.value());
                continue;
            }
            LOGGER.warn("{}@Parser : {} is not a DateParser legal property, it will be ignored ", (Object)field.getName(), (Object)param.name());
        }
        if (format == null) {
            errorOccurs = true;
            LOGGER.error("{}@Parser : DateParser {} property is required", (Object)field.getName(), (Object)"format");
        } else {
            try {
                parser = new DateParser(format, dateClass, locale);
            }
            catch (UsageInvalideException ex) {
                errorOccurs = true;
                LOGGER.error(String.format("%s@Parser : DateParser cannot be instanciated", field.getName()), (Throwable)ex);
            }
        }
        if (errorOccurs) {
            throw new AnnotationProcessorException();
        }
        return parser;
    }

    private <T> AbstractParser<T> getCustomParser(Field field, Parser parserAnnotation, Class<T> fieldConcreteClass) throws AnnotationProcessorException {
        AbstractParser<?> parser = null;
        boolean errorOccurs = false;
        TypeVariable<Class<? extends AbstractParser<?>>>[] types = parserAnnotation.value().getTypeParameters();
        if (types.length != 1) {
            LOGGER.warn("{}@Parser : dunno if {} parser deals with {} class", new Object[]{field.getName(), parserAnnotation.value().getSimpleName(), fieldConcreteClass.getSimpleName()});
        } else {
            types[0].getClass().asSubclass(fieldConcreteClass);
            try {
                types[0].getClass().asSubclass(fieldConcreteClass);
            }
            catch (ClassCastException ex) {
                errorOccurs = true;
                LOGGER.error(String.format("%s@Parser : %s field class must be the class (or super class)  the parser deals with", field.getName(), fieldConcreteClass.getSimpleName()), (Throwable)ex);
            }
        }
        if (!Util.isConcrete(fieldConcreteClass)) {
            errorOccurs = true;
            LOGGER.error("{}@Parser : {} field class must be a concrete class", (Object)field.getName(), (Object)fieldConcreteClass.getSimpleName());
        }
        try {
            parser = parserAnnotation.value().newInstance();
        }
        catch (InstantiationException e) {
            errorOccurs = true;
            LOGGER.error(String.format("%s@Parser : %s can not be instanciated", field.getName(), parserAnnotation.value().getSimpleName()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            errorOccurs = true;
            LOGGER.error(String.format("%s@Parser %s can not be instanciated", field.getName(), parserAnnotation.value().getSimpleName()), (Throwable)e);
        }
        for (Param param : parserAnnotation.params()) {
            String name = param.name();
            String value = param.value();
            Method setter = Util.identifySetter(parserAnnotation.value(), (String)name);
            if (setter == null) {
                LOGGER.error("{}@Parser : no setter found for its {} property", (Object)field.getName(), (Object)name);
                errorOccurs = true;
                continue;
            }
            Class<?> setterParamClass = setter.getParameterTypes()[0];
            try {
                AbstractParser setterParser = AbstractParser.identifyDefaultParser(setterParamClass);
                if (parser == null) continue;
                try {
                    setter.invoke(parser, setterParser.parse(value));
                }
                catch (IllegalAccessException e) {
                    errorOccurs = true;
                    LOGGER.error(String.format("%s@Parser : can not setting %s with value %s ", field.getName(), name, value), (Throwable)e);
                    errorOccurs = true;
                }
                catch (IllegalArgumentException e) {
                    errorOccurs = true;
                    LOGGER.error(String.format("%s@Parser : can not setting %s with value %s ", field.getName(), name, value), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    errorOccurs = true;
                    LOGGER.error(String.format("%s@Parser : can not setting %s with value %s ", field.getName(), name, value), (Throwable)e);
                }
                catch (ParseException e) {
                    errorOccurs = true;
                    LOGGER.error(String.format("%s@Parser : can not parse %s to set %s ", field.getName(), value, name), (Throwable)e);
                }
            }
            catch (UsageInvalideException ex) {
                LOGGER.error("{}@Parser : {} property unable to set - Perhaps if the property class has a string argument constructor, it will be better ... ", new Object[]{field.getName(), name});
                errorOccurs = true;
            }
        }
        if (errorOccurs) {
            throw new AnnotationProcessorException();
        }
        return parser;
    }
}

