/*
 * Decompiled with CFR 0.152.
 */
package olg.csv.bean.annotations.processor;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.Date;
import java.util.Locale;
import olg.csv.base.UsageInvalideException;
import olg.csv.bean.Util;
import olg.csv.bean.annotations.Formatter;
import olg.csv.bean.annotations.Param;
import olg.csv.bean.annotations.processor.AnnotationProcessorException;
import olg.csv.bean.formatter.DateFormatter;
import olg.csv.bean.parser.AbstractParser;
import olg.csv.bean.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormatterProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormatterProcessor.class);
    private static FormatterProcessor instance = new FormatterProcessor();

    private FormatterProcessor() {
    }

    public static FormatterProcessor getInstance() {
        return instance;
    }

    public <T> olg.csv.bean.formatter.Formatter<T> getFormatter(Field field, Class<T> fieldConcreteClass) throws AnnotationProcessorException {
        Class<olg.csv.bean.formatter.Formatter<?>> clazz;
        Object formatter = null;
        Formatter formatterAnnotation = field.getAnnotation(Formatter.class);
        formatter = formatterAnnotation != null ? ((clazz = formatterAnnotation.value()).equals(DateFormatter.class) ? this.getDateFormatter(field, formatterAnnotation, fieldConcreteClass) : this.getCustomFormatter(field, formatterAnnotation, fieldConcreteClass)) : new olg.csv.bean.formatter.Formatter<Date>();
        return formatter;
    }

    private <T> olg.csv.bean.formatter.Formatter<Date> getDateFormatter(Field field, Formatter formatterAnnotation, Class<T> fieldConcreteClass) throws AnnotationProcessorException {
        olg.csv.bean.formatter.Formatter formatter = null;
        String format = null;
        Locale locale = null;
        boolean errorOccurs = false;
        try {
            fieldConcreteClass.asSubclass(Date.class);
        }
        catch (ClassCastException ex) {
            errorOccurs = true;
            LOGGER.error("{}@Formatter : {} field class must extend Date class to instanciate a Date Formatter", (Object)field.getName(), (Object)fieldConcreteClass.getSimpleName());
        }
        if (fieldConcreteClass.isInterface()) {
            errorOccurs = true;
            LOGGER.error("{}@Formatter : {} field class must be a concret class", (Object)field.getName(), (Object)fieldConcreteClass.getSimpleName());
        }
        for (Param param : formatterAnnotation.params()) {
            if (param.name().equals("format")) {
                format = param.value();
                continue;
            }
            if (param.name().equals("locale")) {
                locale = olg.csv.bean.loader.Util.getLocale((String)param.value());
                if (locale != null) continue;
                LOGGER.warn("{}@Formatter : {} Locale property is not an available Locale, it will be ignored", (Object)field.getName(), (Object)param.value());
                continue;
            }
            LOGGER.warn("{}@Formatter : {} is not a DateFormatter legal property, it will be ignored ", (Object)field.getName(), (Object)param.name());
        }
        if (format == null) {
            errorOccurs = true;
            LOGGER.error("{}@Formatter : DateFormatter {} property is required", (Object)field.getName(), (Object)"format");
        } else {
            try {
                formatter = olg.csv.bean.formatter.Formatter.getDateFormatter(format, locale);
            }
            catch (UsageInvalideException ex) {
                errorOccurs = true;
                LOGGER.error(String.format("%s@Formatter : DateParser cannot be instanciated", field.getName()), (Throwable)ex);
            }
        }
        if (errorOccurs) {
            throw new AnnotationProcessorException();
        }
        return formatter;
    }

    private <T> olg.csv.bean.formatter.Formatter<T> getCustomFormatter(Field field, Formatter formatterAnnotation, Class<T> fieldConcreteClass) throws AnnotationProcessorException {
        olg.csv.bean.formatter.Formatter<?> formatter = null;
        boolean errorOccurs = false;
        TypeVariable<Class<? extends olg.csv.bean.formatter.Formatter<?>>>[] types = formatterAnnotation.value().getTypeParameters();
        if (types.length != 1) {
            LOGGER.warn("{}@Formatter : dunno if {} formatter deals with {} class", new Object[]{field.getName(), formatterAnnotation.value().getSimpleName(), fieldConcreteClass.getSimpleName()});
        } else {
            try {
                types[0].getClass().asSubclass(fieldConcreteClass);
            }
            catch (ClassCastException ex) {
                errorOccurs = true;
                LOGGER.error(String.format("%s@Formatter : %s field class must be the class (or super class)  the formatter deals with", field.getName(), fieldConcreteClass.getSimpleName()), (Throwable)ex);
            }
        }
        if (!Util.isConcrete(fieldConcreteClass)) {
            errorOccurs = true;
            LOGGER.error("{}@Formatter : {} field class must be a concret class", (Object)field.getName(), (Object)fieldConcreteClass.getSimpleName());
        }
        try {
            formatter = formatterAnnotation.value().newInstance();
        }
        catch (InstantiationException e) {
            errorOccurs = true;
            LOGGER.error(String.format("%s@Formatter : %s can not be instanciated", field.getName(), formatterAnnotation.value().getSimpleName()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            errorOccurs = true;
            LOGGER.error(String.format("%s@Formatter : %s can not be instanciated", field.getName(), formatterAnnotation.value().getSimpleName()), (Throwable)e);
        }
        for (Param param : formatterAnnotation.params()) {
            String name = param.name();
            String value = param.value();
            Method setter = Util.identifySetter(formatterAnnotation.value(), (String)name);
            if (setter == null) {
                LOGGER.error("{}@Formatter : no setter found for its {} property", (Object)field.getName(), (Object)name);
                errorOccurs = true;
                continue;
            }
            Class<?> setterParamClass = setter.getParameterTypes()[0];
            try {
                AbstractParser setterParser = AbstractParser.identifyDefaultParser(setterParamClass);
                if (formatter == null) continue;
                try {
                    setter.invoke(formatter, setterParser.parse(value));
                }
                catch (IllegalAccessException e) {
                    errorOccurs = true;
                    LOGGER.error(String.format("%s@Formatter : can not set %s with value %s ", field.getName(), name, value), (Throwable)e);
                    errorOccurs = true;
                }
                catch (IllegalArgumentException e) {
                    errorOccurs = true;
                    LOGGER.error(String.format("%s@Formatter : can not set %s with value %s ", field.getName(), name, value), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    errorOccurs = true;
                    LOGGER.error(String.format("%s@Formatter : can not set %s with value %s ", field.getName(), name, value), (Throwable)e);
                }
                catch (ParseException e) {
                    errorOccurs = true;
                    LOGGER.error(String.format("%s@Formatter : can not parse %s to set %s ", field.getName(), value, name), (Throwable)e);
                }
            }
            catch (UsageInvalideException ex) {
                LOGGER.error("{}@Formatter : {} property unable to set - Perhaps if the property class has a string argument constructor, it will be better ... ", new Object[]{field.getName(), name});
                errorOccurs = true;
            }
        }
        if (errorOccurs) {
            throw new AnnotationProcessorException();
        }
        return formatter;
    }
}

