/*
 * Decompiled with CFR 0.152.
 */
package olg.csv.bean.annotations.processor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import olg.csv.base.Cell;
import olg.csv.bean.IBeanProcessor;
import olg.csv.bean.IPropertyProcessor;
import olg.csv.bean.Util;
import olg.csv.bean.annotations.Embedded;
import olg.csv.bean.annotations.processor.RowBeanProcessor;
import olg.csv.bean.impl.AbstractPropertyProcessor;
import olg.csv.bean.impl.BeanProcessor;
import olg.csv.bean.impl.CellProcessor;
import olg.csv.bean.impl.PropertyFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmbeddedProcessor<B> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedProcessor.class);
    private Class<B> clazz;

    public EmbeddedProcessor(Class<B> clazz) {
        this.clazz = clazz;
    }

    public boolean getWritingProcessor(Field field, Map<Integer, List<CellProcessor<B>>> map) {
        Embedded embedded = field.getAnnotation(Embedded.class);
        boolean noError = true;
        if (embedded != null) {
            HashMap cellsMap;
            RowBeanProcessor fieldProcessor;
            String rang = embedded.value();
            int indexBegin = 0;
            try {
                indexBegin = Cell.fromSheetCellNumber((String)rang);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("{}@Embedded : {}", (Object)field.getName(), (Object)ex.getMessage());
                noError = false;
            }
            Class<?> fieldConcreteClass = field.getType();
            if (!Object.class.equals(embedded.concreteClass())) {
                if (!Util.asSubClass(field.getType(), embedded.concreteClass())) {
                    noError = false;
                    LOGGER.error("{}@Embedded : {} concreteClass attribute is not a subclass", (Object)field.getName(), embedded.concreteClass());
                }
                fieldConcreteClass = embedded.concreteClass();
            }
            noError &= this.checkConcreteClass(field, fieldConcreteClass);
            Method getter = Util.identifyGetter(field.getDeclaringClass(), (String)field.getName());
            if (getter == null) {
                LOGGER.error("{}@Embedded : {} has no public getter for this field", (Object)field.getName(), (Object)field.getDeclaringClass().getSimpleName());
                noError = false;
            }
            if (noError &= (fieldProcessor = new RowBeanProcessor(fieldConcreteClass)).getWritingProcessor(cellsMap = new HashMap())) {
                for (Map.Entry entry : cellsMap.entrySet()) {
                    Integer num = indexBegin + (Integer)entry.getKey();
                    if (map.get(num) == null) {
                        map.put(num, new ArrayList());
                    }
                    for (CellProcessor cellProcessor : (List)entry.getValue()) {
                        String name = cellProcessor.getName();
                        if (Cell.defaultCellName((String)String.valueOf(cellProcessor.getRang())).equals(name)) {
                            name = Cell.defaultCellName((String)num.toString());
                        }
                        CellProcessor delegateProcessor = new CellProcessor(num.toString(), name, PropertyFormatter.getDelegatePropertyReader((Method)getter, (String)field.getName(), (PropertyFormatter)cellProcessor.getPropertyFormatter()));
                        map.get(num).add(delegateProcessor);
                    }
                }
            }
        }
        return noError;
    }

    public boolean getReadingProcessor(int translate, Field field, List<IPropertyProcessor<B>> propertyProcessors, Map<Integer, Integer> map) {
        Embedded embedded = field.getAnnotation(Embedded.class);
        boolean noError = true;
        int indexBegin = translate;
        if (embedded != null) {
            ArrayList fieldPropertyProcessors;
            RowBeanProcessor fieldProcessor;
            String rang = embedded.value();
            try {
                indexBegin += Cell.fromSheetCellNumber((String)rang);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("{}@Embedded : {}", (Object)field.getName(), (Object)ex.getMessage());
                noError = false;
            }
            Class<?> fieldConcreteClass = field.getType();
            if (!Object.class.equals(embedded.concreteClass())) {
                if (!Util.asSubClass(field.getType(), embedded.concreteClass())) {
                    noError = false;
                    LOGGER.error("{}@Embedded : {} concreteClass attribute is not a subclass", (Object)field.getName(), embedded.concreteClass());
                }
                fieldConcreteClass = embedded.concreteClass();
            }
            noError &= this.checkConcreteClass(field, fieldConcreteClass);
            Method setter = Util.identifySetter(field.getDeclaringClass(), (String)field.getName());
            if (setter == null) {
                LOGGER.error("{}@Embedded : {} has no public setter for this field", (Object)field.getName(), (Object)field.getDeclaringClass().getSimpleName());
                noError = false;
            }
            if (noError &= (fieldProcessor = new RowBeanProcessor(fieldConcreteClass)).getReadingProcessor(indexBegin, fieldPropertyProcessors = new ArrayList(), map)) {
                BeanProcessor fieldProcess = new BeanProcessor(fieldConcreteClass);
                fieldProcess.addAll(fieldPropertyProcessors);
                propertyProcessors.add(AbstractPropertyProcessor.getComplexPropertyTransformer((IBeanProcessor)fieldProcess, this.clazz, (String)field.getName()));
            }
        }
        return noError;
    }

    private boolean checkConcreteClass(Field field, Class<?> fieldConcreteClass) {
        if (!Util.isConcrete(fieldConcreteClass)) {
            LOGGER.error("{}@Embedded: {}  field class is not a concrete class", (Object)field.getName(), (Object)fieldConcreteClass.getSimpleName());
            return false;
        }
        return true;
    }
}

