/*
 * Decompiled with CFR 0.152.
 */
package olg.csv.bean.annotations.processor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import olg.csv.base.Cell;
import olg.csv.bean.IPropertyProcessor;
import olg.csv.bean.Util;
import olg.csv.bean.annotations.Column;
import olg.csv.bean.annotations.processor.AnnotationProcessorException;
import olg.csv.bean.annotations.processor.FormatterProcessor;
import olg.csv.bean.annotations.processor.ParserProcessor;
import olg.csv.bean.formatter.Formatter;
import olg.csv.bean.getter.AbstractGetter;
import olg.csv.bean.impl.AbstractPropertyProcessor;
import olg.csv.bean.impl.CellProcessor;
import olg.csv.bean.impl.PropertyFormatter;
import olg.csv.bean.parser.AbstractParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColumnProcessor<B> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColumnProcessor.class);
    private static final String DEFAULT_DEFAULT_VALUE = "null";
    private static final String NULL_DEFAULT_VALUE = "\"null\"";
    private Class<B> clazz;

    public ColumnProcessor(Class<B> clazz) {
        this.clazz = clazz;
    }

    public boolean getWritingProcessor(Field field, Map<Integer, List<CellProcessor<B>>> map) {
        Column column = field.getAnnotation(Column.class);
        boolean noError = true;
        if (column != null) {
            String rang = column.value();
            int num = 0;
            String name = column.name();
            Method getter = Util.identifyGetter(field.getDeclaringClass(), (String)field.getName());
            Class<?> fieldConcreteClass = field.getType();
            if (!Object.class.equals(column.concreteClass())) {
                fieldConcreteClass = column.concreteClass();
                noError &= this.chekcAsSubClass(field, column);
            }
            noError &= this.checkConcreteClass(field, fieldConcreteClass);
            try {
                num = Cell.fromSheetCellNumber((String)rang);
                if ("".equals(name)) {
                    name = Cell.defaultCellName((String)rang);
                }
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("{}@Column : {}", (Object)field.getName(), (Object)ex.getMessage());
                noError = false;
            }
            if (getter == null) {
                LOGGER.error("{}@Column : No public getter found", (Object)field.getName());
                noError = false;
            }
            try {
                Formatter<?> formatter = FormatterProcessor.getInstance().getFormatter(field, fieldConcreteClass);
                if (noError) {
                    if (map.get(num) == null) {
                        map.put(num, new ArrayList());
                    }
                    map.get(num).add(new CellProcessor(rang, name, PropertyFormatter.getPropertyReader((Method)getter, (String)field.getName(), formatter, null)));
                }
            }
            catch (AnnotationProcessorException e) {
                noError = false;
            }
        }
        return noError;
    }

    public boolean getReadingProcessor(int translate, Field field, List<IPropertyProcessor<B>> propertyProcessors, Map<Integer, Integer> map) {
        Column column = field.getAnnotation(Column.class);
        boolean noError = true;
        if (column != null) {
            String rang = column.value();
            int num = 0;
            Class<?> fieldConcreteClass = field.getType();
            if (!Object.class.equals(column.concreteClass())) {
                fieldConcreteClass = column.concreteClass();
                noError &= this.chekcAsSubClass(field, column);
            }
            noError &= this.checkConcreteClass(field, fieldConcreteClass);
            AbstractGetter getter = null;
            IPropertyProcessor propertyProcessor = null;
            AbstractParser<?> parser = null;
            try {
                num = Cell.fromSheetCellNumber((String)rang) + translate;
                if (map.get(num) == null) {
                    map.put(num, 0);
                }
                map.put(num, map.get(num) + 1);
                getter = AbstractGetter.getDefault((String)String.valueOf(num), (String)this.getDefaultValue(column));
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("{}@Column : {}", (Object)field.getName(), (Object)ex.getMessage());
                noError = false;
            }
            try {
                parser = ParserProcessor.getInstance().getParser(field, fieldConcreteClass);
            }
            catch (AnnotationProcessorException ex) {
                noError = false;
            }
            Method setter = Util.identifySetter(field.getDeclaringClass(), (String)field.getName());
            if (setter == null) {
                LOGGER.error("{}@Column : {} has no public setter for this field", (Object)field.getName(), (Object)field.getDeclaringClass().getSimpleName());
                noError = false;
            }
            if (parser != null && getter != null && setter != null) {
                try {
                    propertyProcessor = AbstractPropertyProcessor.getSimplePropertyTransformer((AbstractGetter)getter, parser, (String)field.getName(), this.clazz);
                    propertyProcessors.add(propertyProcessor);
                }
                catch (IllegalArgumentException ex) {
                    LOGGER.error("{}@Column : {}", (Object)field.getName(), (Object)ex.getMessage());
                    noError = false;
                }
            }
        }
        return noError;
    }

    private boolean chekcAsSubClass(Field field, Column column) {
        boolean noError = true;
        if (!Util.asSubClass(field.getType(), column.concreteClass())) {
            noError = false;
            LOGGER.error("{}@Column : {} concreteClass attribute is not a subclass", (Object)field.getName(), column.concreteClass());
        }
        return noError;
    }

    private boolean checkConcreteClass(Field field, Class<?> fieldConcreteClass) {
        if (!Util.isConcrete(fieldConcreteClass)) {
            LOGGER.error("{}@Column : {}  field class is not a concrete class", (Object)field.getName(), (Object)fieldConcreteClass.getSimpleName());
            return false;
        }
        return true;
    }

    private String getDefaultValue(Column column) {
        String value = column.defaultValue();
        if (DEFAULT_DEFAULT_VALUE.equals(value)) {
            value = null;
        }
        if (NULL_DEFAULT_VALUE.equals(value)) {
            value = DEFAULT_DEFAULT_VALUE;
        }
        return value;
    }
}

