/*
 * Decompiled with CFR 0.152.
 */
package olg.csv.bean;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import olg.csv.base.IReader;
import olg.csv.base.IWriter;
import olg.csv.base.csv.CSVReader;
import olg.csv.base.csv.CSVSettings;
import olg.csv.base.csv.CSVWriter;
import olg.csv.base.ods.ODSReader;
import olg.csv.base.ods.ODSSettings;
import olg.csv.base.ods.ODSWriter;
import olg.csv.bean.BeanReader;
import olg.csv.bean.BeanWriter;
import olg.csv.bean.IBeanProcessor;
import olg.csv.bean.IRowProcessor;
import olg.csv.bean.PropertyException;
import olg.csv.bean.annotations.processor.AnnotationProcessorException;
import olg.csv.bean.annotations.processor.RowBeanProcessor;
import olg.csv.bean.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RowBean<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RowBean.class);
    private Class<T> clazz;
    private RowBeanProcessor<T> rowBeanProcessor;

    public RowBean(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("RowBean constructor class argument must not be null");
        }
        this.clazz = clazz;
        this.rowBeanProcessor = new RowBeanProcessor<T>(this.clazz);
    }

    public IReader getReader(File in) throws IOException, AnnotationProcessorException {
        if (in == null) {
            throw new IllegalArgumentException("RowBean.getReader file argument must not be null");
        }
        if (!in.exists()) {
            throw new IllegalArgumentException(String.format("RowBean.getReader file argument [%s] doesn't exist", in.getAbsolutePath()));
        }
        if (RowBean.isCSVFile(in)) {
            return new CSVReader(in, this.rowBeanProcessor.getReadingCSVSettings());
        }
        if (RowBean.isODSFile(in)) {
            return new ODSReader(in, this.rowBeanProcessor.getReadingODSSettings());
        }
        throw new IllegalArgumentException("RowBean.getReader has not identified the file in argument as an ODS or CSV file. Use instead the constructor of the class of your choice : ODSReader or CSVReader.");
    }

    public IWriter getWriter(File out) throws AnnotationProcessorException, IOException {
        if (out == null) {
            throw new IllegalArgumentException("RowBean.getWriter file argument must not be null");
        }
        if (RowBean.isCSVFile(out)) {
            return new CSVWriter(out, this.rowBeanProcessor.getWritingCSVSettings());
        }
        if (RowBean.isODSFile(out)) {
            return new ODSWriter(out, this.rowBeanProcessor.getWritingODSSettings());
        }
        throw new IllegalArgumentException("RowBean.getWriter has not identified the file in argument as an ODS or CSV file.  Use instead the constructor of the class ODSWriter or CSVWriter");
    }

    public List<T> fromFile(File in, CSVSettings csvSettings) throws AnnotationProcessorException, IOException {
        return this.fromReader((IReader)new CSVReader(in, csvSettings), in);
    }

    public List<T> fromFile(File in, ODSSettings odsSettings) throws AnnotationProcessorException, IOException {
        return this.fromReader((IReader)new ODSReader(in, odsSettings), in);
    }

    public List<T> fromFile(File in) throws AnnotationProcessorException, IOException {
        return this.fromReader(this.getReader(in), in);
    }

    public void toFile(List<T> beans, File out) throws AnnotationProcessorException, IOException {
        this.toWriter(beans, this.getWriter(out), out);
    }

    public void toFile(List<T> beans, File out, CSVSettings csvSettings) throws AnnotationProcessorException, IOException {
        this.toWriter(beans, (IWriter)new CSVWriter(out, csvSettings), out);
    }

    public void toFile(List<T> beans, File out, ODSSettings odsSettings) throws AnnotationProcessorException, IOException {
        this.toWriter(beans, (IWriter)new ODSWriter(out, odsSettings), out);
    }

    private static boolean isCSVFile(File file) {
        return file.getName().matches(".+\\.(:?csv|CSV|TXT|txt|dat|DAT)$");
    }

    private static boolean isODSFile(File file) {
        return file.getName().matches(".+\\.(:?ods|ODS)$");
    }

    private IRowProcessor<T> getRowProcessor() throws AnnotationProcessorException {
        return this.rowBeanProcessor.getRowProcessor();
    }

    private IBeanProcessor<T> getBeanProcessor() throws AnnotationProcessorException {
        return this.rowBeanProcessor.getBeanProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> fromReader(IReader fileReader, File in) throws AnnotationProcessorException {
        ArrayList<Object> list = new ArrayList<Object>();
        BeanReader reader = null;
        int count = 0;
        try {
            reader = new BeanReader(this.getBeanProcessor(), fileReader);
            while (reader.hasNext()) {
                try {
                    ++count;
                    list.add(reader.next());
                }
                catch (ParseException ex) {
                    LOGGER.warn(String.format("Error at record[%s] on Reading file[%s] ", count, in.getAbsolutePath()), (Throwable)ex);
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toWriter(List<T> beans, IWriter fileWriter, File out) throws AnnotationProcessorException {
        if (beans == null) {
            throw new IllegalArgumentException();
        }
        BeanWriter writer = null;
        try {
            writer = new BeanWriter(this.getRowProcessor(), fileWriter);
            for (T bean : beans) {
                try {
                    writer.write(bean);
                }
                catch (PropertyException ex) {
                    LOGGER.warn(String.format("Error on writing bean[%s] in file[%s] ", bean, out.getAbsolutePath()), (Throwable)ex);
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

