/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cotelab.euler;

import java.util.Arrays;
import java.util.LinkedList;
import net.sf.cotelab.util.math.Primes;

public class Problem29 {
    public static void main(String[] args) {
        Problem29 prob = new Problem29();
        int result = prob.calc();
        System.out.println("result = " + result);
    }

    public int calc() {
        Primes primes = new Primes();
        Object[] facts = new Facts[99];
        for (int n = 2; n <= 100; ++n) {
            facts[n - 2] = new Facts(primes, n);
        }
        Arrays.sort(facts);
        for (int i = 0; i < facts.length; ++i) {
            System.out.println("{" + ((Facts)facts[i]).getN() + "} " + Arrays.toString(((Facts)facts[i]).getUniqueFactors()) + " " + Arrays.toString(((Facts)facts[i]).getFactorCounts()) + " " + Arrays.toString(((Facts)facts[i]).getPrimeFactors()));
        }
        return 0;
    }

    private class Facts
    implements Comparable<Facts> {
        private long[] factorCounts = null;
        private long n = -1L;
        private long[] primeFactors = null;
        private Primes primes = null;
        private long[] uniqueFactors = null;

        public Facts(Primes primes, long n) {
            this.n = n;
            this.primes = primes;
        }

        private long[] calcFactorCounts() {
            long[] uf = this.getUniqueFactors();
            long[] pf = this.getPrimeFactors();
            long[] fc = new long[uf.length];
            int pfc = 0;
            for (int i = 0; i < uf.length; ++i) {
                long f = uf[i];
                fc[i] = 0L;
                while (pfc < pf.length && f == pf[pfc]) {
                    int n = i;
                    fc[n] = fc[n] + 1L;
                    ++pfc;
                }
            }
            return fc;
        }

        private long[] calcUniqueFactors() {
            int i;
            long[] result = null;
            long[] raw = this.getPrimeFactors();
            LinkedList<Long> clean = new LinkedList<Long>();
            long oldEntry = -1L;
            for (i = 0; i < raw.length; ++i) {
                if (raw[i] == oldEntry) continue;
                oldEntry = raw[i];
                clean.add(oldEntry);
            }
            int count = clean.size();
            result = new long[count];
            for (i = 0; i < count; ++i) {
                result[i] = (Long)clean.get(i);
            }
            return result;
        }

        @Override
        public int compareTo(Facts o) {
            long[] myUF = this.getUniqueFactors();
            long[] hisUF = o.getUniqueFactors();
            int compLen = Math.min(myUF.length, hisUF.length);
            int lengthDif = myUF.length - hisUF.length;
            for (int i = 0; i < compLen; ++i) {
                long diff = myUF[i] - hisUF[i];
                if (diff < 0L) {
                    return -1;
                }
                if (diff <= 0L) continue;
                return 1;
            }
            return lengthDif;
        }

        public long[] getFactorCounts() {
            if (this.factorCounts == null) {
                this.factorCounts = this.calcFactorCounts();
            }
            return this.factorCounts;
        }

        public long getN() {
            return this.n;
        }

        public long[] getPrimeFactors() {
            if (this.primeFactors == null) {
                this.primeFactors = this.primes.primeFactors(this.n);
            }
            return this.primeFactors;
        }

        public long[] getUniqueFactors() {
            if (this.uniqueFactors == null) {
                this.uniqueFactors = this.calcUniqueFactors();
            }
            return this.uniqueFactors;
        }
    }
}

