/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cotelab.euler;

import java.util.Arrays;
import java.util.LinkedList;
import net.sf.cotelab.util.math.MathFunctions;

public class Problem23 {
    public static final int LIMIT_2_ABUNDANTS = 28124;
    public static final int MINIMUM_2_ABUNDANTS = 24;
    public static final int MINIMUM_ABUNDANT = 12;
    public static final int RANGE_2_ABUNDANTS = 28100;

    private static boolean isAbundant(int number) {
        long[] properDivisors = MathFunctions.properDivisors((long)number);
        long sum = MathFunctions.sum((long[])properDivisors);
        boolean abundant = sum > (long)number;
        return abundant;
    }

    private static Integer[] listInterestingAbundantNumbers() {
        int interestingAbundantMax = 28124;
        LinkedList<Integer> interestingAbundantList = new LinkedList<Integer>();
        for (int i = 12; i < interestingAbundantMax; ++i) {
            boolean abundant = Problem23.isAbundant(i);
            if (!abundant) continue;
            interestingAbundantList.add(i);
        }
        Integer[] result = interestingAbundantList.toArray(new Integer[0]);
        int count = result.length;
        System.out.println("number of interesting abundant numbers = " + count);
        return result;
    }

    public static void main(String[] args) {
        int i;
        Integer[] abundants = Problem23.listInterestingAbundantNumbers();
        boolean[] canBeSum = new boolean[28124];
        int sum = 0;
        Arrays.fill(canBeSum, false);
        for (i = 0; i < abundants.length; ++i) {
            int a = abundants[i];
            for (int j = 0; j < abundants.length; ++j) {
                int b = abundants[j];
                int s = a + b;
                if (s >= 28124) continue;
                canBeSum[s] = true;
            }
        }
        for (i = 0; i < 28124; ++i) {
            if (canBeSum[i] || (sum += i) >= 0) continue;
            System.err.println("overflow: sum = " + sum);
            System.exit(1);
        }
        System.out.println("sum = " + sum);
    }
}

