/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cotelab.euler;

public class Problem14 {
    private static long collatzSeqLen(long startTerm) {
        long length = 1L;
        long term = startTerm;
        while (term != 1L) {
            ++length;
            term = Problem14.nextCollatzTerm(term);
        }
        return length;
    }

    public static void main(String[] args) {
        long longestLength = 0L;
        long longestStartTerm = 0L;
        for (long startTerm = 1L; startTerm < 1000000L; ++startTerm) {
            long length = Problem14.collatzSeqLen(startTerm);
            if (length <= longestLength) continue;
            longestLength = length;
            longestStartTerm = startTerm;
        }
        System.out.println("Starting term " + longestStartTerm + " yields a sequence of length " + longestLength);
    }

    private static long nextCollatzTerm(long term) {
        long nextTerm = term % 2L == 0L ? term / 2L : 1L + term * 3L;
        return nextTerm;
    }
}

