/*
 * Copyright 2008 Malcolm A. Edgar
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.sf.click.control;

import java.io.Serializable;

import net.sf.click.util.HtmlStringBuffer;

/**
 * Provides an interface for rendering output to an efficient string buffer.
 * <p/>
 * Implementations of this interface will normally render HTML markup.
 *
 * @author Malcolm Edgar
 */
public interface Renderable extends Serializable {

    /**
     * Render output, normally HTML markup, to the given buffer.
     *
     * @param buffer the string buffer to render output to
     */
    public void render(HtmlStringBuffer buffer);

}
