/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;

public class SessionMap
implements Map {
    protected HttpSession session;

    public SessionMap(HttpSession value) {
        this.session = value;
    }

    public int size() {
        if (this.session != null) {
            int size = 0;
            Enumeration enumeration = this.session.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++size;
            }
            return size;
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object key) {
        if (this.session != null && key != null) {
            return this.session.getAttribute(key.toString()) != null;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Object get(Object key) {
        if (this.session != null && key != null) {
            return this.session.getAttribute(key.toString());
        }
        return null;
    }

    public Object put(Object key, Object value) {
        if (this.session != null && key != null) {
            Object out = this.session.getAttribute(key.toString());
            this.session.setAttribute(key.toString(), value);
            return out;
        }
        return null;
    }

    public Object remove(Object key) {
        if (this.session != null && key != null) {
            Object out = this.session.getAttribute(key.toString());
            this.session.removeAttribute(key.toString());
            return out;
        }
        return null;
    }

    public void putAll(Map map) {
        if (this.session != null && map != null) {
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                String key = i.next().toString();
                Object value = map.get(key);
                this.session.setAttribute(key, value);
            }
        }
    }

    public void clear() {
        if (this.session != null) {
            Enumeration enumeration = this.session.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String name = enumeration.nextElement().toString();
                this.session.removeAttribute(name);
            }
        }
    }

    public Set keySet() {
        if (this.session != null) {
            HashSet keySet = new HashSet();
            Enumeration enumeration = this.session.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                keySet.add(enumeration.nextElement());
            }
            return keySet;
        }
        return Collections.EMPTY_SET;
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        if (this.session != null) {
            HashSet<Object> entrySet = new HashSet<Object>();
            Enumeration enumeration = this.session.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String name = enumeration.nextElement().toString();
                Object value = this.session.getAttribute(name);
                entrySet.add(value);
            }
            return entrySet;
        }
        return Collections.EMPTY_SET;
    }
}

