/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.util;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

public class HtmlStringBuffer {
    public static final String[] JS_ATTRIBUTES = new String[]{"onload", "onunload", "onclick", "ondblclick", "onmousedown", "onmouseup", "onmouseover", "onmousemove", "onmouseout", "onfocus", "onblur", "onkeypress", "onkeydown", "onkeyup", "onsubmit", "onreset", "onselect", "onchange"};
    protected final StringBuffer buffer;

    public HtmlStringBuffer(int length) {
        this.buffer = new StringBuffer(length);
    }

    public HtmlStringBuffer() {
        this.buffer = new StringBuffer(64);
    }

    public void append(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value parameter");
        }
        this.buffer.append(value);
    }

    public void appendEscaped(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value parameter");
        }
        this.buffer.append(StringEscapeUtils.escapeHtml((String)value.toString()));
    }

    public void appendAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Null name parameter");
        }
        if (value != null) {
            this.buffer.append(" ");
            this.buffer.append(name);
            this.buffer.append("=\"");
            if (this.isJavaScriptAttribute(name)) {
                this.buffer.append(value);
            } else {
                this.buffer.append(StringEscapeUtils.escapeHtml((String)value.toString()));
            }
            this.buffer.append("\"");
        }
    }

    public void appendAttribute(String name, int value) {
        if (name == null) {
            throw new IllegalArgumentException("Null name parameter");
        }
        this.buffer.append(" ");
        this.buffer.append(name);
        this.buffer.append("=\"");
        this.buffer.append(value);
        this.buffer.append("\"");
    }

    public void appendAttributeDisabled() {
        this.buffer.append(" disabled=\"disabled\"");
    }

    public void appendAttributeReadonly() {
        this.buffer.append(" readonly=\"readonly\"");
    }

    public void appendAttributes(Map attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Null attributes parameter");
        }
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String name = i.next().toString();
            if (name.equals("id")) continue;
            Object value = attributes.get(name);
            this.appendAttribute(name, value);
        }
    }

    public void elementEnd(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name parameter");
        }
        this.buffer.append("</");
        this.buffer.append(name);
        this.buffer.append(">");
    }

    public void closeTag() {
        this.buffer.append(">");
    }

    public void elementEnd() {
        this.buffer.append("/>");
    }

    public void elementStart(String name) {
        this.buffer.append("<");
        this.buffer.append(name);
    }

    public boolean isJavaScriptAttribute(String name) {
        if (name.length() < 6 || name.length() > 11) {
            return false;
        }
        if (!name.startsWith("on")) {
            return false;
        }
        for (int i = 0; i < JS_ATTRIBUTES.length; ++i) {
            if (!JS_ATTRIBUTES[i].equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public int length() {
        return this.buffer.length();
    }

    public String toString() {
        return this.buffer.toString();
    }
}

