/*
 * Decompiled with CFR 0.152.
 */
package net.sf.click.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.click.util.HtmlStringBuffer;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class Format {
    public String getEmptyString() {
        return "&nbsp";
    }

    public String currency(Number number) {
        if (number != null) {
            NumberFormat format = NumberFormat.getCurrencyInstance();
            return format.format(number.doubleValue());
        }
        return this.getEmptyString();
    }

    public String date(Date date, String pattern) {
        if (date != null) {
            if (pattern == null) {
                throw new IllegalArgumentException("Null pattern parameter");
            }
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            return format.format(date);
        }
        return this.getEmptyString();
    }

    public String date(Date date) {
        if (date != null) {
            DateFormat format = DateFormat.getDateInstance();
            return format.format(date);
        }
        return this.getEmptyString();
    }

    public String decimal(Number number, String pattern) {
        if (number != null) {
            if (pattern == null) {
                throw new IllegalArgumentException("Null pattern parameter");
            }
            DecimalFormat format = new DecimalFormat(pattern);
            return format.format(number.doubleValue());
        }
        return this.getEmptyString();
    }

    public String decimal(Number number) {
        if (number != null) {
            DecimalFormat format = new DecimalFormat();
            return format.format(number.doubleValue());
        }
        return this.getEmptyString();
    }

    public String email(String email) {
        return this.email(email, null);
    }

    public String email(String email, String attribute) {
        if (StringUtils.isNotBlank((String)email)) {
            if (email.indexOf(64) != -1 && !email.startsWith("@") && !email.endsWith("@")) {
                HtmlStringBuffer buffer = new HtmlStringBuffer(128);
                buffer.elementStart("a");
                buffer.appendAttribute("href", "mailto:" + email);
                if (StringUtils.isNotBlank((String)attribute)) {
                    buffer.append(" ");
                    buffer.append(attribute);
                }
                buffer.closeTag();
                buffer.appendEscaped(email);
                buffer.elementEnd("a");
                return buffer.toString();
            }
            return email;
        }
        return this.getEmptyString();
    }

    public String html(Object value) {
        if (value != null) {
            return StringEscapeUtils.escapeHtml((String)value.toString());
        }
        return this.getEmptyString();
    }

    public String javascript(String value) {
        if (value != null) {
            return StringEscapeUtils.escapeJavaScript((String)value);
        }
        return "";
    }

    public String limitLength(String value, int maxlength) {
        return this.limitLength(value, maxlength, "...");
    }

    public String limitLength(String value, int maxlength, String suffix) {
        String ret = value;
        if (value.length() > maxlength) {
            ret = value.substring(0, maxlength - suffix.length()) + suffix;
        }
        return ret;
    }

    public String link(String value) {
        return this.link(value, null);
    }

    public String link(String value, String attribute) {
        if (StringUtils.isNotBlank((String)value)) {
            HtmlStringBuffer buffer = new HtmlStringBuffer(128);
            if (value.indexOf(64) != -1 && !value.startsWith("@") && !value.endsWith("@")) {
                buffer.elementStart("a");
                buffer.appendAttribute("href", "mailto:" + value);
                if (StringUtils.isNotBlank((String)attribute)) {
                    buffer.append(" ");
                    buffer.append(attribute);
                }
                buffer.closeTag();
                buffer.appendEscaped(value);
                buffer.elementEnd("a");
            } else if (value.startsWith("http")) {
                int index = value.indexOf("//");
                index = index != -1 ? (index += 2) : 0;
                buffer.elementStart("a");
                buffer.appendAttribute("href", value);
                if (StringUtils.isNotBlank((String)attribute)) {
                    buffer.append(" ");
                    buffer.append(attribute);
                }
                buffer.closeTag();
                buffer.appendEscaped(value.substring(index));
                buffer.elementEnd("a");
            } else if (value.startsWith("www")) {
                buffer.elementStart("a");
                buffer.appendAttribute("href", "http://" + value);
                if (StringUtils.isNotBlank((String)attribute)) {
                    buffer.append(" ");
                    buffer.append(attribute);
                }
                buffer.closeTag();
                buffer.appendEscaped(value);
                buffer.elementEnd("a");
            } else {
                buffer.append(value);
            }
            return buffer.toString();
        }
        return this.getEmptyString();
    }

    public String percentage(Number number) {
        if (number != null) {
            NumberFormat format = NumberFormat.getPercentInstance();
            return format.format(number.doubleValue());
        }
        return this.getEmptyString();
    }

    public String time(Date date) {
        if (date != null) {
            DateFormat format = DateFormat.getTimeInstance();
            return format.format(date);
        }
        return this.getEmptyString();
    }

    public String string(Object object) {
        if (object != null) {
            return object.toString();
        }
        return this.getEmptyString();
    }
}

